package hpdos.lib;

import hpdos.ConfigConstants;
import hpdos.message.MessageConstants;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

import java.io.*;



public class RocksDBStorageService implements StorageService {
    //private final ConcurrentHashMap<String, StorageModel> memoryKVStore;

    private static final String dbPath = "./rocksdb-data/";
    private RocksDB rocksDB;

    public RocksDBStorageService() {
        //this.memoryKVStore = new ConcurrentHashMap<>();
        RocksDB.loadLibrary();
        //If the file does not exist, create the file first
        try (final Options options = new Options().setCreateIfMissing(true)) {
            try {
                rocksDB = RocksDB.open(options, dbPath);
                options.useDirectReads();
                options.setIncreaseParallelism(12);
                //options.writeBufferSize(); //16GB
                //options.optimizeForPointLookup(256);
            } catch (RocksDBException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Persistent Store Opened Successfully!");
    }

    public static byte[] toStream(StorageModel val) {
        // Reference for stream of bytes
        if (val == null)
            return null;
        byte[] stream = null;
        // ObjectOutputStream is used to convert a Java object into OutputStream
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos)) {
            oos.writeObject(val);
            stream = baos.toByteArray();
        } catch (IOException e) {
            // Error in serialization
            e.printStackTrace();
        }
        return stream;
    }

    public static StorageModel toStorageModel(byte[] stream) {
        StorageModel st = null;
        if (stream == null)
            return null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(stream);
             ObjectInputStream ois = new ObjectInputStream(bais)) {
            st = (StorageModel) ois.readObject();
        } catch (IOException | ClassNotFoundException e) {
            // Error in de-serialization
            e.printStackTrace();
        } // You are converting an invalid stream to StorageModel

        return st;
    }

    @Override
    public StoredModel create(String key, StorageModel value) {
/*        try {
            if (memoryKVStore.putIfAbsent(key, value) != null)
                return new StoredModel(null, MessageConstants.STATUS_KEY_EXISTS);
            return new StoredModel(value, MessageConstants.STATUS_OK);
        } catch (Exception e) {
            return null;
        }*/
        try {
            if (rocksDB.get(key.getBytes()) == null) {
                rocksDB.put(key.getBytes(), toStream(value));
                if (ConfigConstants.DEBUG) {
                    System.out.println("Created object with key = " + key);
                }
                //return new StoredModel(value, MessageConstants.STATUS_OK);
            } else {
                return new StoredModel(null, MessageConstants.STATUS_KEY_EXISTS);
            }
        } catch (RocksDBException e) {
            e.printStackTrace();
        }
        return new StoredModel(value, MessageConstants.STATUS_OK);
    }

    @Override
    public StoredModel readByKey(String key) {
        /*if (!memoryKVStore.containsKey(key))
            return new StoredModel(null, MessageConstants.STATUS_KEY_NOT_FOUND);
        return new StoredModel(memoryKVStore.get(key), MessageConstants.STATUS_OK);*/
        StorageModel tmpStorageModel = null;
        try {
            tmpStorageModel = toStorageModel(rocksDB.get(key.getBytes()));
            if (tmpStorageModel == null) {
                return new StoredModel(null, MessageConstants.STATUS_KEY_NOT_FOUND);
            }

        } catch (RocksDBException e) {
            e.printStackTrace();
        }
        return new StoredModel(tmpStorageModel, MessageConstants.STATUS_OK);
    }

    @Override
    public StoredModel update(String key, StorageModel value) {
  /*      StorageModel previousValue = memoryKVStore.get(key);
        if (previousValue == null)
            return new StoredModel(null, MessageConstants.STATUS_KEY_NOT_FOUND);
        else if (previousValue.getAccessType() == MessageConstants.METADATA_ACCESS_PRIVATE
                && !previousValue.getOwner().equals(value.getOwner()))
            return new StoredModel(null, MessageConstants.STATUS_UNAUTHORIZED_PRIVATE_KEY_ACCESS);

        // the request will have the old version number of the data to be inserted, we only update the data
        // with a new version number if at the time of update the two versions match
        // else we reject the update
        StorageModel newValue = value.createVersionUpdatedModel();
        boolean status = memoryKVStore.replace(key, value, newValue); // the equals method is overridden in Storage model
        // to equate two objects based on their version numbers
        if (status)
            return new StoredModel(value, MessageConstants.STATUS_OK);
        else
            return new StoredModel(null, MessageConstants.STATUS_UPDATE_VERSION_MISMATCH);*/

        StorageModel previousValue;
        boolean status = false;
        try {
            previousValue = toStorageModel(rocksDB.get(key.getBytes()));
            if (previousValue == null)
                return new StoredModel(null, MessageConstants.STATUS_KEY_NOT_FOUND);
            else if (previousValue.getAccessType() == MessageConstants.METADATA_ACCESS_PRIVATE
                    && !previousValue.getOwner().equals(value.getOwner()))
                return new StoredModel(null, MessageConstants.STATUS_UNAUTHORIZED_PRIVATE_KEY_ACCESS);

            // the request will have the old version number of the data to be inserted, we only update the data
            // with a new version number if at the time of update the two versions match
            // else we reject the update
            StorageModel newValue = value.createVersionUpdatedModel();
            if (newValue.getVersion() > previousValue.getVersion()) {
                status = true;
                rocksDB.put(key.getBytes(), toStream(value));
                if (ConfigConstants.DEBUG) {
                    System.out.println("Updated object with key = " + key);
                }
            }
        } catch (RocksDBException e) {
            e.printStackTrace();
        }
        if (status)
            return new StoredModel(value, MessageConstants.STATUS_OK);
        else
            return new StoredModel(null, MessageConstants.STATUS_UPDATE_VERSION_MISMATCH);
    }

    @Override
    public StoredModel delete(String key, StorageModel value) {
        /*StorageModel previousValue = memoryKVStore.get(key);
        if (previousValue == null)
            return new StoredModel(null, MessageConstants.STATUS_KEY_NOT_FOUND);
        else if (previousValue.getAccessType() == MessageConstants.METADATA_ACCESS_PRIVATE
                && !previousValue.getOwner().equals(value.getOwner()))
            return new StoredModel(null, MessageConstants.STATUS_UNAUTHORIZED_PRIVATE_KEY_ACCESS);
        boolean status = memoryKVStore.remove(key, value);
        if (status)
            return new StoredModel(previousValue, MessageConstants.STATUS_OK);
        else
            return new StoredModel(null, MessageConstants.STATUS_UPDATE_VERSION_MISMATCH);
    }*/
        StorageModel previousValue = null;
        //boolean status = false;
        try {
            previousValue = toStorageModel(rocksDB.get(key.getBytes()));
            if (previousValue == null)
                return new StoredModel(null, MessageConstants.STATUS_KEY_NOT_FOUND);
            else {
                if (previousValue.getAccessType() == MessageConstants.METADATA_ACCESS_PRIVATE
                        && !previousValue.getOwner().equals(value.getOwner()))
                    return new StoredModel(null, MessageConstants.STATUS_UNAUTHORIZED_PRIVATE_KEY_ACCESS);
                if (value.getVersion() < previousValue.getVersion())
                    return new StoredModel(null, MessageConstants.STATUS_UPDATE_VERSION_MISMATCH);
                    //status = true;
                    rocksDB.delete(key.getBytes());
                    if (ConfigConstants.DEBUG) {
                        System.out.println("Deleted object with key = " + key);
                    }

            }
        } catch (RocksDBException e) {
            e.printStackTrace();
        }
            return new StoredModel(previousValue, MessageConstants.STATUS_OK);
    }
}
