package hpdos.lib;

import java.time.Instant;


public class MasterFollower {
    private String ip;
    private int port;
    private final String followerID;
    private long lastSeen;

    public MasterFollower(String ip, int port, String followerID) {
        this.ip = ip;
        this.port = port;
        this.followerID = followerID;
        this.lastSeen = Instant.now().getEpochSecond();
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFollowerID() {
        return followerID;
    }

    public long getLastSeen() {
        return lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    @Override
    public String toString() {
        return "MasterFollower {" +
                "ip='" + ip + '\'' +
                ", port=" + port +
                ", followerID='" + followerID + '\'' +
                '}';
    }
}
