/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package HpdosClient;

import HpdosClient.MessageFormat.MessageConstants;
import HpdosClient.MessageFormat.RequestBuilder;
import com.google.common.base.Stopwatch;
import hpdos.grpc.*;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.concurrent.*;

public class ClientRunner {
    public static int parallelCount = 10;
    public static int runtime = 0;
    private final String clientID;
    public static String propertiesFile;
    private int cCreate, cRead, cUpdate, cDelete;
    public boolean experimentEnded = false;
    private List<Follower> replicaSet;
    private Queue<Long> createTime, updateTime, readTime, deleteTime;

    public ClientRunner() {
        clientID = UUID.randomUUID().toString();
        Properties properties = new Properties();
        try {
            InputStream inputStream = new FileInputStream(propertiesFile);
            properties.load(inputStream);
            parallelCount = Integer.parseInt((String) properties.get("app.thread_count"));
            runtime = Integer.parseInt((String) properties.get("app.runtime"));
            cCreate = Integer.parseInt((String) properties.get("app.cycle_create"));
            cRead = Integer.parseInt((String) properties.get("app.cycle_read"));
            cUpdate = Integer.parseInt((String) properties.get("app.cycle_update"));
            cDelete = Integer.parseInt((String) properties.get("app.cycle_delete"));

            createTime = new ConcurrentLinkedQueue<>();
            updateTime = new ConcurrentLinkedQueue<>();
            readTime = new ConcurrentLinkedQueue<>();
            deleteTime = new ConcurrentLinkedQueue<>();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    public String getGreeting() {
        return "Hello World!";
    }

    // create a metadata block
    public long create(NetworkServiceGrpc.NetworkServiceBlockingStub stub, String key, String value) {
        ArrayList<Request> request = new ArrayList<>();
        request.add(RequestBuilder.buildRequest(MessageConstants.METADATA_CREATE,
                0, value.length(), key,
                0, MessageConstants.METADATA_ACCESS_PRIVATE, this.clientID, value));
        Packet packet = RequestBuilder.buildPacket(request);
        long timestampCreateStart = System.currentTimeMillis();
        Packet response = stub.createMetadata(packet);
        return timestampCreateStart;
    }

    // read back the metadata
    public Map.Entry<Packet, Long> read(ArrayList<ManagedChannel> channels, String key) {
        int rnd = new Random().nextInt(channels.size());
        NetworkServiceGrpc.NetworkServiceBlockingStub stub = NetworkServiceGrpc.newBlockingStub(channels.get(rnd));
        ArrayList<Request> request = new ArrayList<>();
        request.add(RequestBuilder.buildRequest(MessageConstants.METADATA_READ,
                0, 0, key, 0, MessageConstants.METADATA_ACCESS_PRIVATE, this.clientID, ""));
        Packet packet = RequestBuilder.buildPacket(request);
        long timestampReadStart = System.currentTimeMillis();
        Packet response = stub.readMetadata(packet);
//        System.out.println(response);
        return new AbstractMap.SimpleEntry<>(response, timestampReadStart);
    }

    public long update(NetworkServiceGrpc.NetworkServiceBlockingStub stub, String key, String value, int version) {
        ArrayList<Request> request = new ArrayList<>();
        request.add(RequestBuilder.buildRequest(MessageConstants.METADATA_UPDATE,
                version, value.length(), key,
                0, MessageConstants.METADATA_ACCESS_PRIVATE, this.clientID, value));
        Packet packet = RequestBuilder.buildPacket(request);
        long timestampCreateStart = System.currentTimeMillis();
        Packet response = stub.updateMetadata(packet);
        return timestampCreateStart;
    }

    public long delete(NetworkServiceGrpc.NetworkServiceBlockingStub stub, String key, int version) {
        ArrayList<Request> request = new ArrayList<>();
        request.add(RequestBuilder.buildRequest(MessageConstants.METADATA_DELETE,
                version, 0, key,
                0, MessageConstants.METADATA_ACCESS_PRIVATE, this.clientID, ""));
        Packet packet = RequestBuilder.buildPacket(request);
        long timestampCreateStart = System.currentTimeMillis();
        Packet response = stub.deleteMetadata(packet);
        return timestampCreateStart;
    }

    public double runExperiment(String id, long experimentStartTime) {
        final ManagedChannel masterChannel = ManagedChannelBuilder.
                forAddress(ConfigConstants.HOST, ConfigConstants.PORT)
                .usePlaintext()
                .build();
        ArrayList<ManagedChannel> channels = new ArrayList<>();
        channels.add(masterChannel);
        for (Follower follower: replicaSet) {
            ManagedChannel channel = ManagedChannelBuilder.
                    forAddress(follower.getIp(), follower.getPort())
                    .usePlaintext()
                    .build();
            channels.add(channel);
        }

        for (;;) {

            String key = id + (int) (Math.random() * Integer.MAX_VALUE),
                    value = "dummy",
                    updatedValue = "dummyUpdated";
            NetworkServiceGrpc.NetworkServiceBlockingStub stub = NetworkServiceGrpc.newBlockingStub(masterChannel);
            for (int j = 0; j < cCreate; j++) {
                long timestampCreateStart = create(stub, key, value);
                createTime.add(System.currentTimeMillis() - timestampCreateStart);
            }
            for (int j = 0; j < cRead; j++) {
                AbstractMap.Entry<Packet, Long> data = read(channels, key);
                readTime.add(System.currentTimeMillis() - data.getValue());
            }

            for (int j = 0; j < cUpdate; j++) {
                AbstractMap.Entry<Packet, Long> data = read(channels, key);
                long timestampUpdateStart = update(stub, key, updatedValue,
                        data.getKey().getResponse(0).getAck().getVersion());
                readTime.add(System.currentTimeMillis() - data.getValue());
                updateTime.add(System.currentTimeMillis() - timestampUpdateStart);
            }

            for (int j = 0; j < cDelete; j++) {
                AbstractMap.Entry<Packet, Long> data = read(channels, key);
                long timestampDeleteStart = delete(stub, key, data.getKey().getResponse(0).getAck().getVersion());
                readTime.add(System.currentTimeMillis() - data.getValue());
                deleteTime.add(System.currentTimeMillis() - timestampDeleteStart);
            }
            long currentTime = System.currentTimeMillis();
            if ((currentTime - experimentStartTime) >= runtime * 1000L)
                break;
        }
//        System.out.println(id + "runtime " + (System.currentTimeMillis() - startTime) +
//                "ms qps " + qps);
        masterChannel.shutdown();
        return 0;
    }

    public void retrieveFollowerList() {
        final ManagedChannel channel = ManagedChannelBuilder.
                forAddress(ConfigConstants.HOST, ConfigConstants.PORT)
                .usePlaintext()
                .build();
        NetworkServiceGrpc.NetworkServiceBlockingStub stub = NetworkServiceGrpc.newBlockingStub(channel);
        ResponseList responseList = stub.getReadReplicaList(null);
        this.replicaSet = responseList.getFollowerList();
        for (Follower follower: this.replicaSet) {
            System.out.println(follower);
        }
        channel.shutdown();
    }

    private void timerService() {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask() {
            @Override
            public void run() {
                if (experimentEnded) {
                    timer.cancel();
                    timer.purge();
                }
                System.out.println("Experiment ran: " + stopwatch);
            }
        }, 5000, 5000);
    }

    private void printStatistics(double totalRuntime) {
        long readQps = 0, createQps = 0, updateQps = 0, deleteQps = 0;
        double avgRead = 0, avgCreate = 0, avgUpdate = 0, avgDelete = 0;
        for (Long time: this.readTime) {
            readQps++;
            avgRead += time;
        }
        avgRead /= readQps * 1.0;
        for (Long time: this.createTime) {
            createQps++;
            avgCreate += time;
        }
        avgCreate /= createQps * 1.0;
        for (Long time: this.updateTime) {
            updateQps++;
            avgUpdate += time;
        }
        avgUpdate /= updateQps * 1.0;
        for (Long time: this.deleteTime) {
            deleteQps++;
            avgDelete += time;
        }
        avgDelete /= deleteQps * 1.0;
        double totalQps = readQps + createQps + updateQps + deleteQps;
        System.out.println("Total runtime: " + totalRuntime);
        System.out.println("Read: " + readQps + " Create: " + createQps
                + " Update: " + updateQps + " Delete: " + deleteQps + " Total: " + totalQps);
        totalRuntime /= 1000;
        //System.out.println("Total QPS: " + totalQps / totalRuntime + " avg query time: " + (totalQps * parallelCount / (totalRuntime)));
        System.out.println("Total QPS: " + totalQps / totalRuntime + " avg query time: " +
                ((avgRead + avgCreate + avgUpdate + avgDelete) / 4));
        System.out.println("Read QPS: " + readQps / totalRuntime + " avg query time: " + avgRead);
        System.out.println("Create QPS: " + createQps / totalRuntime + " avg query time: " + avgCreate);
        System.out.println("Update QPS: " + updateQps / totalRuntime + " avg query time: " + avgUpdate);
        System.out.println("Delete QPS: " + deleteQps / totalRuntime + " avg query time: " + avgDelete);
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        propertiesFile = args[0];
        ClientRunner clientRunner = new ClientRunner();
        System.out.println(clientRunner.getGreeting());
        System.out.println("Thread count: " + parallelCount + " runtime: " + runtime + "s");
        ExecutorService executorService = Executors.newFixedThreadPool(parallelCount);
        Thread.sleep(1000); // let things settle down a bit
        clientRunner.retrieveFollowerList();
        Set<Callable<Double>> callables = new HashSet<>();
        final long startTime = System.currentTimeMillis();
        for (int i = 0; i < parallelCount; i++) {
            int finalI = i;
            callables.add(() -> clientRunner.runExperiment(Integer.toString(finalI), startTime));
        }
        clientRunner.timerService();
        List<Future<Double>> futures = executorService.invokeAll(callables);
        for (Future<Double> future: futures) {
            future.get();
        }
        clientRunner.experimentEnded = true;
        long endTime = System.currentTimeMillis();
        double totalRuntime = endTime - startTime;
        clientRunner.printStatistics(totalRuntime);

        executorService.shutdown();
        executorService.awaitTermination(2, TimeUnit.SECONDS);
    }
}
