#ifndef __PARSER__
#define __PARSER__
#include "definitions.p4"

/*************************************************************************
*********************** P A R S E R  ***********************************
*************************************************************************/

parser c_parser(packet_in packet,
                out headers hdr,
                inout metadata meta,
                inout standard_metadata_t standard_metadata) {

    state start {
        transition select(standard_metadata.ingress_port) {
            default: parse_ethernet;
        }
    }

    state parse_packet_out {
        packet.extract(hdr.packet_out);
        transition parse_ethernet;
    }

    state parse_ethernet {
        packet.extract(hdr.ethernet);
        transition select(hdr.ethernet.etherType) {
            TYPE_IPV4: parse_ipv4;
            default: accept;
        }
    }

    state parse_ipv4 {
        packet.extract(hdr.ipv4);
        transition select(hdr.ipv4.protocol) {
            PROTO_TCP: parse_tcp;
            PROTO_UDP: parse_udp;
            default: accept;
        }
    }

  // header check_t {
  //  bit<8> traffic_code; // Req: 1, Response: 2
  //  bit<16> len; //object length
  //  bit<DATALEN_BY_TWO> data; //data object
  //  bit<16> chk; //checksum
  //  }

    state parse_udp{
        packet.extract(hdr.udp);
        transition accept;
    }

/*     state parse_udp{
        packet.extract(hdr.udp);
        //packet.extract(hdr.check);
        //transition accept;

        transition select(hdr.udp.dstPort) {
            5001: parse_check;
            default: accept;
        }	
    }

    state parse_check{
        packet.extract(hdr.check);
        transition accept;
    } */
  
    state parse_tcp{
        packet.extract(hdr.tcp);
        transition accept;
    }
}

/*************************************************************************
***********************  D E P A R S E R  *******************************
*************************************************************************/

control c_deparser(packet_out packet, in headers hdr) {
    apply {
        packet.emit(hdr.packet_in);
        packet.emit(hdr.packet_out);
        packet.emit(hdr.ethernet);
        packet.emit(hdr.ipv4);
        packet.emit(hdr.tcp);
        packet.emit(hdr.udp);
        //packet.emit(hdr.check);
    }
}
#endif
