/* -*- P4_16 -*- */
#include <core.p4>
#include <v1model.p4>
#include "include/headers.p4"
#include "include/parser.p4"
#include "include/checksums.p4"
#include "include/definitions.p4"
#define MAX_PORTS 255

    
/*************************************************************************
**************  I N G R E S S   P R O C E S S I N G   *******************
*************************************************************************/


control c_ingress(inout headers hdr,
                  inout metadata meta,
                  inout standard_metadata_t standard_metadata) {
    // ARP packets forwarding tables 
    action fwd_act( bit<16> prt) {
        standard_metadata.egress_spec = prt;
    }

    action drop_act() {
        mark_to_drop();
    }

    table arp_tbl {
        key={
            standard_metadata.ingress_port : exact;
        }
        actions={
            fwd_act;
            drop_act;
        }
        size = 10;
    }

    apply {
        // forwarding ARP packets via SmartNICs
          if(hdr.ethernet.etherType==TYPE_ARP){
                arp_tbl.apply();
                return;
          } 
          else if (hdr.ipv4.isValid()) {
                    //  if ingrees port is logical v0.0(768) then it means it is a packet from host
                //For UDP packets   
		if(hdr.ipv4.protocol == PROTO_UDP){
			if(standard_metadata.ingress_port==768){ //incoming port is vf0.0
                standard_metadata.egress_spec = 769; //send to vf0.1
                hdr.ipv4.ttl = hdr.ipv4.ttl - 1;
                return;
            }
        	if(standard_metadata.ingress_port==769){  //incoming port is vf0.1
                standard_metadata.egress_spec = 768;  //send to vf0.0 
                hdr.ipv4.ttl = hdr.ipv4.ttl - 1;
                return;
            }
        }
				                            
/* 		if(standard_metadata.ingress_port==768){  //incoming port is vf0.0
                standard_metadata.egress_spec = 768;  //send to vf0.0 		
                bit<48> tmp_mac;
				bit<32> tmp_ip;
				bit<16> tmp_port;

				tmp_mac = hdr.ethernet.dstAddr;
				hdr.ethernet.dstAddr = hdr.ethernet.srcAddr;
				hdr.ethernet.srcAddr = tmp_mac;

				tmp_ip = hdr.ipv4.dstAddr;
				hdr.ipv4.dstAddr = hdr.ipv4.srcAddr;
				hdr.ipv4.srcAddr = tmp_ip;
			
				tmp_port = hdr.udp.dstPort;
				hdr.udp.dstPort = hdr.udp.srcPort;
 				hdr.udp.srcPort = tmp_port; 

				hdr.ipv4.ttl = hdr.ipv4.ttl - 1;

				hdr.check.traffic_code = 2;
			        //hdr.check.chk = 1;	
                                return; 
            }*/
        
		   //ONLY FOR ICMP PACKETS
		   if(hdr.ipv4.protocol == PROTO_ICMP){
                   	if(standard_metadata.ingress_port==768){
                        	standard_metadata.egress_spec = 769;
		   	}else if(standard_metadata.ingress_port==769){
				standard_metadata.egress_spec = 768;
		   	}
		   	return;
                   }	
         }
     }
}

/*************************************************************************
****************  E G R E S S   P R O C E S S I N G   *******************
*************************************************************************/

control c_egress(inout headers hdr,
                 inout metadata meta,
                 inout standard_metadata_t standard_metadata) {
        apply {

        }  // apply close
} // egress control close


/*************************************************************************
***********************  S W I T C H  *******************************
*************************************************************************/
V1Switch(c_parser(),
         c_verify_checksum(),
         //c_verify_object_checksum(),
         c_ingress(),
         c_egress(),
         c_compute_checksum(),
         //c_compute_object_checksum(),
         c_deparser()) main;
