#include "includes/defines.p4"
#include "includes/headers.p4"
#include "includes/parsers.p4"
#include "includes/checksum.p4"
#include "ethernet.p4"
#include "ipv4.p4"
#include "mds.p4"
#include "cache.p4"
#include "heavy_hitter.p4"
#include "value.p4"

#define PKT_INSTANCE_TYPE_NORMAL 0
#define PKT_INSTANCE_TYPE_INGRESS_CLONE 1
#define PKT_INSTANCE_TYPE_EGRESS_CLONE 2
#define PKT_INSTANCE_TYPE_COALESCED 3
#define PKT_INSTANCE_TYPE_INGRESS_RECIRC 4
#define PKT_INSTANCE_TYPE_REPLICATION 5
#define PKT_INSTANCE_TYPE_RESUBMIT 6

header_type resubmit_meta_t {
    fields {
        resubmit_key: 8;
    }
}

metadata resubmit_meta_t resubmit_meta;

field_list resubmit_metadata {
    resubmit_meta.resubmit_key;
}

action _resubmit_act() {
    resubmit(resubmit_metadata);
}

table _resubmit{
    actions {
        _resubmit_act;
    }
}

control ingress {
    if (udp.dstPort == MDS_PORT) {
        routePacket();
    } else if (standard_metadata.instance_type == PKT_INSTANCE_TYPE_NORMAL) {
        apply(_resubmit);
    } else {

        process_cache();
        process_value();
    }
    apply(ipv4_route);
}
control egress {
    if (nc_hdr.op == NC_READ_REQUEST and nc_cache_md.cache_exist != 1) {
        heavy_hitter();
    }
    apply(ethernet_set_mac);
}