/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package hpdos;

import hpdos.grpc.HeartbeatRequest;
import hpdos.grpc.HeartbeatResponse;
import hpdos.grpc.HeartbeatServiceGrpc;
import hpdos.handler.HeartbeatHandler;
import hpdos.handler.IOHandler;
import hpdos.handler.NetworkHandler;
import hpdos.handler.ReplicateHandler;
import hpdos.lib.*;
import hpdos.message.MessageConstants;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class MetadataServer {
    private Server server;
    private final HashMap<String, MasterFollower> followers;
    private final String serverID;
    private boolean isMaster = false;
    private int port;
    private final String host;
    private IOHandler ioHandler;
    private ReplicationService replicationService;

    public MetadataServer() {
        this.followers = new HashMap<>();
        this.serverID = UUID.randomUUID().toString();
        this.port = 10000 + (int)(Math.random() * 40000);
        this.host = "localhost";
        this.replicationService = null;
    }

    public String getGreeting() {
        return "Hello World!";
    }

    public boolean startMasterServices() {
        this.server = ServerBuilder.forPort(ConfigConstants.PORT)
                .addService(new NetworkHandler(this.ioHandler, this.replicationService))
                .addService(new HeartbeatHandler(followers, serverID))
                .build();
        try {
            this.server.start();
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean startFollowerServices() {
        // In case of followers NetworkHandler will only serve read requests for private metadata
        // Other network handler services will fail
        this.server = ServerBuilder.forPort(port)
                .addService(new NetworkHandler(this.ioHandler, this.replicationService))
                .addService(new ReplicateHandler(this.ioHandler))
                .build();
        try {
            this.server.start();
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
    public void blockForIO(Server server) {
        if (server == null)
            return;
        try {
            server.awaitTermination();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void announceToMaster() {
        final ManagedChannel channel = ManagedChannelBuilder.
                forAddress(ConfigConstants.HOST, ConfigConstants.PORT)
                .usePlaintext()
                .build();
        HeartbeatServiceGrpc.HeartbeatServiceBlockingStub stub = HeartbeatServiceGrpc.newBlockingStub(channel);
        HeartbeatRequest.Builder heartbeat = HeartbeatRequest.newBuilder();
        heartbeat.setPacketType(MessageConstants.PACKET_METADATA_REQUEST);
        heartbeat.setOperationType(MessageConstants.MASTER_HEARTBEAT);
        heartbeat.setFollowerID(this.serverID);
        heartbeat.setIp(this.host);
        heartbeat.setPort(this.port);
        try {
            HeartbeatResponse response = stub.heartbeat(heartbeat.build());
        } catch (Exception e) {
            System.out.println("Metadata Master not found, electing self as master");
            this.isMaster = true;
            this.port = ConfigConstants.PORT;
        }
        channel.shutdown();
    }

    private void startHeartbeatService() {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask() {
            @Override
            public void run() {
                announceToMaster();
            }
        }, ConfigConstants.HEARTBEAT_INTERVAL, ConfigConstants.HEARTBEAT_INTERVAL);
    }

    private IOHandler initStorage(int backend) {
        StorageService storageService;
        switch (backend) {
            case ConfigConstants.BACKEND_IN_MEMORY:
                storageService = new MemoryStorageService();
                break;
            case ConfigConstants.ROCKSDB_BACKEND:
                storageService = new RocksDBStorageService();
                // Uncomment the code below for local testing
/*                StorageModel value = new StorageModel(1,5,"Hello",0,"A", "World");
                storageService.create("Hello",value);
                value = new StorageModel(1,5,"Hello",0,"A", "World");
                storageService.update("Hello",value);
                storageService.readByKey("Hello");
                storageService.delete("Hello",value);*/
                break;
            case ConfigConstants.BINARY_TREE_BACKEND:
            case ConfigConstants.LSM_BACKEND:
            default: return null;
        }
        return new IOHandler(storageService, this.isMaster);
    }

    private void cleanup () {
        if (this.replicationService != null) {
            try {
                this.replicationService.cleanup();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
    public static void main(String[] args) {
        MetadataServer metaDataServer = new MetadataServer();

        System.out.println(metaDataServer.getGreeting());
        System.out.println("Starting Metadata service");
        System.out.println("Initialising storage service");

        // Check ConfigConstants for available storage options
        //metaDataServer.ioHandler = metaDataServer.initStorage(ConfigConstants.BACKEND_IN_MEMORY);
        metaDataServer.ioHandler = metaDataServer.initStorage(ConfigConstants.ROCKSDB_BACKEND);
        if (metaDataServer.ioHandler == null) {
            System.out.println("Storage server initialisation error");
            return;
        }
        System.out.println("Searching for MetadataMaster");
        metaDataServer.announceToMaster();
        if (metaDataServer.isMaster) {
            metaDataServer.replicationService = new InlineReplicationService(metaDataServer.followers);
            System.out.println("Started master replication module");
            boolean status = metaDataServer.startMasterServices();
            System.out.println("Master ID: " + metaDataServer.serverID);
            if (status) {
                System.out.println("Starting Master MetadataServer at: " + ConfigConstants.PORT);
                metaDataServer.blockForIO(metaDataServer.server);
            }
            else
                System.out.println("Failed to create server");
        } else {
            System.out.println("Master Node detected.\nStarting heartbeat service");
            metaDataServer.startHeartbeatService();
            System.out.println("Starting replication service");
            boolean status = metaDataServer.startFollowerServices();
            if (status) {
                System.out.println("Starting Follower MetadataServer at: " + metaDataServer.port);
                metaDataServer.blockForIO(metaDataServer.server);
            }
            else
                System.out.println("Failed to create server");
        }

        // Adding a shutdown hook
        Runtime current = Runtime.getRuntime();
        current.addShutdownHook(new Thread(metaDataServer::cleanup));
    }
}
