package hpdos.handler;

import com.google.common.base.Stopwatch;
import hpdos.grpc.*;
import hpdos.message.MessageConstants;
import hpdos.message.ResponseBuilder;
import io.grpc.stub.StreamObserver;

public class ReplicateHandler extends ReplicationServiceGrpc.ReplicationServiceImplBase {
    private final IOHandler ioHandler;
    public ReplicateHandler(IOHandler ioHandler) {
        this.ioHandler = ioHandler;
    }
    @Override
    public void replicateMetadata(ReplicationRequest replicationRequest, StreamObserver<ReplicationResponse> responseObserver) {
        ReplicationResponse responsePacket = null;
//        System.out.println("Replication request " + replicationRequest);
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        if (replicationRequest.getPacketType() == MessageConstants.PACKET_METADATA_REQUEST) {
            if (replicationRequest.getRequestList().size() > 1)
                System.out.println("REQUEST BATCHING");
            for (Request request: replicationRequest.getRequestList()) {
                if (request.getOperationType() == MessageConstants.METADATA_CREATE) {
                    Response response = ioHandler.create(request);
                    responsePacket = ResponseBuilder.buildReplicationResponse(response);
                } else if (request.getOperationType() == MessageConstants.METADATA_UPDATE) {
                    Response response = ioHandler.update(request);
                    responsePacket = ResponseBuilder.buildReplicationResponse(response);
                } else if (request.getOperationType() == MessageConstants.METADATA_DELETE) {
                    Response response = ioHandler.delete(request);
                    responsePacket = ResponseBuilder.buildReplicationResponse(response);
                }
//                System.out.println(responsePacket);
                responseObserver.onNext(responsePacket);
            }
            responseObserver.onCompleted();
        }
        stopwatch.stop();
//        System.out.println("Replicate Handler " + stopwatch);
    }

}
