package hpdos.handler;

import hpdos.grpc.HeartbeatRequest;
import hpdos.grpc.HeartbeatResponse;
import hpdos.grpc.HeartbeatServiceGrpc;
import hpdos.lib.MasterFollower;
import hpdos.message.MessageConstants;
import io.grpc.stub.StreamObserver;

import java.time.Instant;
import java.util.HashMap;

public class HeartbeatHandler extends HeartbeatServiceGrpc.HeartbeatServiceImplBase {
    private final HashMap<String, MasterFollower> followers;
    private final String serverID;
    public HeartbeatHandler(HashMap<String, MasterFollower> followers, String serverID) {
        this.followers = followers;
        this.serverID = serverID;
    }

    @Override
    public void heartbeat(HeartbeatRequest request, StreamObserver<HeartbeatResponse> heartbeatResponseStreamObserver) {
        if (!followers.containsKey(request.getFollowerID())) {
            System.out.println("New follower autodiscovery. Added to system " + request);
            followers.put(request.getFollowerID(), new MasterFollower(request.getIp(),
                    request.getPort(), request.getFollowerID()));
        } else {
            MasterFollower follower = followers.get(request.getFollowerID());
            follower.setLastSeen(Instant.now().getEpochSecond());
        }
        HeartbeatResponse.Builder response = HeartbeatResponse.newBuilder();
        response.setPacketType(MessageConstants.PACKET_METADATA_RESPONSE);
        response.setOperationType(MessageConstants.MASTER_HEARTBEAT);
        response.setMasterID(this.serverID);
        heartbeatResponseStreamObserver.onNext(response.build());
        heartbeatResponseStreamObserver.onCompleted();
    }
}
