package HpdosClient.lib;

import HpdosClient.ConfigConstants;
import HpdosClient.MessageFormat.MessageConstants;
import HpdosClient.MessageFormat.RequestBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import hpdos.grpc.*;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

import java.util.*;

public class StorageService {

    private final String clientID;
    private ManagedChannel masterChannel;
    private ArrayList<ManagedChannel> channels;
    private NetworkServiceGrpc.NetworkServiceFutureStub masterStub;
    private final ArrayList<NetworkServiceGrpc.NetworkServiceFutureStub> stubs;
    private List<Follower> replicaSet;

    public StorageService(String clientID) {
        this.clientID = clientID;
        this.stubs = new ArrayList<>();
    }

    public void retrieveFollowerList() {
        NetworkServiceGrpc.NetworkServiceBlockingStub stub = NetworkServiceGrpc.newBlockingStub(this.masterChannel);
        ResponseList responseList = stub.getReadReplicaList(null);
        this.replicaSet = responseList.getFollowerList();
//        for (Follower follower: this.replicaSet) {
//            System.out.println(follower);
//        }
    }

    public void cleanup() {
        for (ManagedChannel channel: this.channels)
            channel.shutdown();
    }

    public void initStorage() {
        masterChannel = ManagedChannelBuilder.
                forAddress(ConfigConstants.HOST, ConfigConstants.PORT)
                .usePlaintext()
                .build();
        channels = new ArrayList<>();
        channels.add(masterChannel);
        masterStub = NetworkServiceGrpc.newFutureStub(this.masterChannel);
        retrieveFollowerList();
        for (Follower follower: replicaSet) {
            ManagedChannel channel = ManagedChannelBuilder.
                    forAddress(follower.getIp(), follower.getPort())
                    .usePlaintext()
                    .build();
            channels.add(channel);
            NetworkServiceGrpc.NetworkServiceFutureStub stub = NetworkServiceGrpc.newFutureStub(channel);
            stubs.add(stub);
        }
    }

    public ListenableFuture<Packet> create(String key, String value, int accessType) {
        ArrayList<Request> request = new ArrayList<>();
        request.add(RequestBuilder.buildRequest(MessageConstants.METADATA_CREATE,
                0, value.length(), key,
                0, accessType, this.clientID, value));
        Packet packet = RequestBuilder.buildPacket(request);
        return this.masterStub.createMetadata(packet);
    }

    public ListenableFuture<Packet> read(String key) {
        int rnd = new Random().nextInt(this.stubs.size());
        NetworkServiceGrpc.NetworkServiceFutureStub stub = this.stubs.get(rnd);
        ArrayList<Request> request = new ArrayList<>();
        request.add(RequestBuilder.buildRequest(MessageConstants.METADATA_READ,
                0, 0, key, 0, MessageConstants.METADATA_ACCESS_PRIVATE, this.clientID, ""));
        Packet packet = RequestBuilder.buildPacket(request);
        return stub.readMetadata(packet);
    }

    public ListenableFuture<Packet> update(String key, String value, int version) {
        ArrayList<Request> request = new ArrayList<>();
        request.add(RequestBuilder.buildRequest(MessageConstants.METADATA_UPDATE,
                version, value.length(), key,
                0, MessageConstants.METADATA_ACCESS_PRIVATE, this.clientID, value));
        Packet packet = RequestBuilder.buildPacket(request);
        return this.masterStub.updateMetadata(packet);
    }

    public ListenableFuture<Packet> delete(String key, int version) {
        ArrayList<Request> request = new ArrayList<>();
        request.add(RequestBuilder.buildRequest(MessageConstants.METADATA_DELETE,
                version, 0, key,
                0, MessageConstants.METADATA_ACCESS_PRIVATE, this.clientID, ""));
        Packet packet = RequestBuilder.buildPacket(request);
        return this.masterStub.deleteMetadata(packet);
    }


}
