package HpdosClient.lib;

import hpdos.grpc.Ack;

import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class StorageModel {
    private int version;
    private int dataSize;
    private final String key; // key is immutable
    private long crc;
    private int accessType;
    private String value;
    private final String owner; // ownership is immutable

    public StorageModel(int version, int dataSize, String key, int accessType, String owner, long crc, String value) {
        this.version = version;
        this.dataSize = dataSize;
        this.key = key;
        this.accessType = accessType;
        this.value = value;
        this.owner = owner;
        // calculate CRC32 based on the value field
        this.crc = crc;
    }

    public void updateData(Ack ack) {
        this.version = ack.getVersion();
        this.dataSize = ack.getDataSize();
        this.value = ack.getValue();
        this.crc = ack.getCrc();
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getDataSize() {
        return dataSize;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public String getKey() {
        return key;
    }

    public long getCrc() {
        return crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    public int getAccessType() {
        return accessType;
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOwner() {
        return owner;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (obj.getClass() != this.getClass())
            return false;
        StorageModel model = (StorageModel) obj;
        return this.getKey().equals(model.getKey());
    }

    @Override
    public String toString() {
        return "key: " + this.key + "\n" +
                "dataSize: " + this.dataSize + "\n" +
                "version: " + this.version + "\n" +
                "owner: " + this.owner + "\n" +
                "accessType: " + this.accessType + "\n" +
                "crc: " + this.crc + "\n" +
                "value: " + this.value;
    }

}
