package HpdosClient.MessageFormat;
import hpdos.grpc.*;

import java.util.ArrayList;

public class ResponseBuilder {

    public static Ack buildAck(int version, int dataSize, String key, long crc, String value) {
        Ack.Builder ack = Ack.newBuilder();
        ack.setKey(key);
        ack.setVersion(version);
        ack.setDataSize(dataSize);
        ack.setCrc(crc);
        ack.setValue(value);
        return ack.build();
    }

    public static Nack buildNack(int version, String key) {
        Nack.Builder nack = Nack.newBuilder();
        nack.setKey(key);
        nack.setVersion(version);
        return nack.build();
    }

    public static Response buildResponsePacket(int operationType, int status,
                                               Ack ack,
                                               Nack nack) {
        Response.Builder response = Response.newBuilder();
        response.setOperationType(operationType);
        response.setStatus(status);
        if (ack != null)
            response.setAck(ack);
        else
            response.clearAck();
        if (nack != null)
            response.setNack(nack);
        else
            response.clearNack();
        return response.build();
    }

    public static Packet buildPacket(ArrayList<Response> responses) {
        Packet.Builder packet = Packet.newBuilder();
        packet.setPacketType(MessageConstants.PACKET_METADATA_RESPONSE);
        packet.addAllResponse(responses);
        return packet.build();
    }

    public static Packet buildPacket(Response response) {
        Packet.Builder packet = Packet.newBuilder();
        packet.setPacketType(MessageConstants.PACKET_METADATA_RESPONSE);
        packet.addResponse(response);
        return packet.build();
    }
}
