package HpdosClient.MessageFormat;

import hpdos.grpc.Packet;
import hpdos.grpc.Request;

import java.util.ArrayList;

public class RequestBuilder {
    public static Request buildRequest(int operationType, int version,
                                       int dataSize, String key, int crc,
                                       int accessType, String clientID, String value) {
        Request.Builder request = Request.newBuilder();
        request.setOperationType(operationType);
        request.setVersion(version);
        request.setDataSize(dataSize);
        request.setKey(key);
        request.setCrc(crc);
        request.setAccessType(accessType);
        request.setClientID(clientID);
        request.setValue(value);

        return request.build();
    }

    public static Packet buildPacket(ArrayList<Request> requests) {
        Packet.Builder packet = Packet.newBuilder();
        packet.setPacketType(MessageConstants.PACKET_METADATA_REQUEST);
        packet.addAllRequest(requests);
        return packet.build();
    }

}
