/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package HpdosClient;

import HpdosClient.MessageFormat.MessageConstants;
import HpdosClient.lib.StorageModel;
import HpdosClient.lib.StorageService;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import hpdos.grpc.*;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.netty.util.concurrent.FutureListener;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.concurrent.*;

public class ClientRunner {
    public static int concurrency;
    public static int runtime;
    private final String clientID;
    public static String propertiesFile;
    private int cCreate, cRead, cUpdate, cDelete;
    public boolean experimentEnded = false;
    private List<Follower> replicaSet;
    private Queue<Long> createTime, updateTime, readTime, deleteTime;
    private final Properties properties;
    private final List<StorageModel> generatedPacket;
    private Semaphore limiter = null;
    private final int cpuCount;
    public ClientRunner() {
        clientID = UUID.randomUUID().toString();
        generatedPacket = Collections.synchronizedList(new ArrayList<>());
        properties = new Properties();
        cpuCount = Runtime.getRuntime().availableProcessors();
        try {
            InputStream inputStream = new FileInputStream(propertiesFile);
            this.properties.load(inputStream);
            System.out.println((String) properties.get("app.concurrency"));
            concurrency = Integer.parseInt((String) properties.get("app.concurrency"));
            this.limiter = new Semaphore(concurrency / cpuCount);
            runtime = Integer.parseInt((String) properties.get("app.runtime"));

            this.cCreate = Integer.parseInt((String) properties.get("app.cycle_create"));
            this.cRead = Integer.parseInt((String) properties.get("app.cycle_read"));
            this.cUpdate = Integer.parseInt((String) properties.get("app.cycle_update"));
            this.cDelete = Integer.parseInt((String) properties.get("app.cycle_delete"));

            this.createTime = new ConcurrentLinkedQueue<>();
            this.updateTime = new ConcurrentLinkedQueue<>();
            this.readTime = new ConcurrentLinkedQueue<>();
            this.deleteTime = new ConcurrentLinkedQueue<>();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    public String getGreeting() {
        return "Hello World!";
    }

    private String createString() {
        double dataSize = Double.parseDouble((String) properties.get("app.data_size"));
        dataSize /= 2.0; // Java strings are 2B long
        String conversionFactor = (String) properties.get("app.data_conversion_factor");
        int multiplier = 1;
        switch (conversionFactor) {
            case "G": multiplier *= 1000;
            case "M": multiplier *= 1000;
            case "K": multiplier *= 1000;
        }
        char[] data = new char[(int)(dataSize * multiplier)];
        return new String(data);
    }

    private void seedServer(StorageService storageService, String value) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(10);
        for (int i = 0; i < 10; i++) {
            String key = Integer.toString((int) (Math.random() * Integer.MAX_VALUE));
            ListenableFuture<Packet> res = storageService.create(key, value, MessageConstants.METADATA_ACCESS_PRIVATE);
            StorageModel model = new StorageModel(0, value.length(), key,
                    MessageConstants.METADATA_ACCESS_PRIVATE, clientID, 0, value);
            res.addListener(() -> {
                try {
                    Packet packet = res.get();
                    for (Response response: packet.getResponseList()) {
//                        System.out.println("seed: " + response);
                        if (response.getStatus() == MessageConstants.STATUS_OK) {
                            model.updateData(response.getAck());
                            generatedPacket.add(model);
                        }
                    }
                } catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                latch.countDown();
            }, MoreExecutors.directExecutor());
        }
        latch.await();
    }

    public double runExperiment(StorageService storageService) throws InterruptedException {

        String value = createString(), updatedValue = createString();
        double totalBracket = this.cCreate + this.cRead + this.cUpdate + this.cDelete;
        double createBracket, readBracket, updateBracket, deleteBracket;

        createBracket = this.cCreate * 1.0 / totalBracket;
        readBracket = createBracket + this.cRead / totalBracket;
        updateBracket = readBracket + this.cUpdate / totalBracket;
        deleteBracket = updateBracket + this.cDelete / totalBracket;
        System.out.println("Starting experiment");
        do {
            limiter.acquire();
            double toss = Math.random();
            if (toss < createBracket) {
//                System.out.println("create");
                String key = Integer.toString((int) (Math.random() * Integer.MAX_VALUE));
                StorageModel model = new StorageModel(0, value.length(), key,
                        MessageConstants.METADATA_ACCESS_PRIVATE, clientID, 0, value);
                final long createStart = System.currentTimeMillis();
                ListenableFuture<Packet> res = storageService.create(model.getKey(), model.getValue(), model.getAccessType());
                res.addListener(() -> {
                    try {
                        Packet packet = res.get();
//                        System.out.println("packet " + packet);
                        for (Response response: packet.getResponseList()) {
                            if (response.getStatus() == MessageConstants.STATUS_OK) {
                                model.updateData(response.getAck());
                                generatedPacket.add(model);
                            }
//                            else
//                                System.out.println("error packet " + response);
                        }
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                    this.createTime.add(System.currentTimeMillis() - createStart);
                    limiter.release();
                }, MoreExecutors.directExecutor());
            } else if (toss < readBracket) {
//                System.out.println("read");
                int index = (int) (Math.random() * generatedPacket.size());
                StorageModel sendPacket = this.generatedPacket.get(index);
                final long readStart = System.currentTimeMillis();
                ListenableFuture<Packet> res = storageService.read(sendPacket.getKey());
                res.addListener(() -> {
                    try {
                        Packet packet = res.get();
//                        System.out.println("packet " + packet);
                        for (Response response: packet.getResponseList()) {
                            if (response.getStatus() == MessageConstants.STATUS_OK)
                                if (sendPacket.getKey().equals(response.getAck().getKey())) {
                                    synchronized (sendPacket) {
                                        sendPacket.updateData(response.getAck());
                                    }
                                }
//                            else
//                                System.out.println("error packet " + response);
                        }
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                    readTime.add(System.currentTimeMillis() - readStart);
                    limiter.release();
                }, MoreExecutors.directExecutor());
            } else if (toss < updateBracket) {
//                System.out.println("update");
                int index = (int) (Math.random() * generatedPacket.size());
                StorageModel sendPacket = this.generatedPacket.get(index);

                final long updateStart = System.currentTimeMillis();
                ListenableFuture<Packet> res = storageService.update(sendPacket.getKey(), updatedValue,
                        sendPacket.getVersion());
                res.addListener(() -> {
                    try {
                        Packet packet = res.get();
//                        System.out.println("packet " + packet);
                        for (Response response: packet.getResponseList()) {
                            if (response.getStatus() == MessageConstants.STATUS_OK)
                                if (sendPacket.getKey().equals(response.getAck().getKey())) {
                                    synchronized (sendPacket) {
                                        sendPacket.updateData(response.getAck());
                                    }
                                }
//                            else
//                                System.out.println("error packet " + response);
                        }
                        updateTime.add(System.currentTimeMillis() - updateStart);
                        limiter.release();
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }, MoreExecutors.directExecutor());
            } else {
//                System.out.println("delete");
                int index = (int) (Math.random() * generatedPacket.size());
                StorageModel sendPacket = this.generatedPacket.get(index);
                final long deleteStart = System.currentTimeMillis();
                ListenableFuture<Packet> res = storageService.delete(sendPacket.getKey(), sendPacket.getVersion());
                res.addListener(() -> {
                    try {
                        Packet packet = res.get();
//                        System.out.println("packet " + packet);
                        for (Response response: packet.getResponseList()) {
                            if (response.getStatus() == MessageConstants.STATUS_OK)
                                if (sendPacket.getKey().equals(response.getAck().getKey())) {
                                    synchronized (sendPacket) {
                                        generatedPacket.remove(sendPacket);
                                    }
                                }
//                            else
//                                System.out.println("error packet " + response);
                        }
                        deleteTime.add(System.currentTimeMillis() - deleteStart);
                        limiter.release();
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }, MoreExecutors.directExecutor());
//                deleteTime.add(System.currentTimeMillis() - timestampDeleteStart);
            }
        } while (!this.experimentEnded);
//        System.out.println(id + "runtime " + (System.currentTimeMillis() - startTime) +
//                "ms qps " + qps);
        return 0;
    }

    private void timerService() {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask() {
            @Override
            public void run() {
                if (experimentEnded) {
                    timer.cancel();
                    timer.purge();
                }
                System.out.println("Experiment ran: " + stopwatch);
            }
        }, 5000, 5000);
    }

    private void printStatistics(double totalRuntime) {
        long readQps = 0, createQps = 0, updateQps = 0, deleteQps = 0;
        double avgRead = 0, avgCreate = 0, avgUpdate = 0, avgDelete = 0;
        for (Long time: this.readTime) {
            readQps++;
            avgRead += time;
        }
        avgRead /= readQps * 1.0;
        for (Long time: this.createTime) {
            createQps++;
            avgCreate += time;
        }
        avgCreate /= createQps * 1.0;
        for (Long time: this.updateTime) {
            updateQps++;
            avgUpdate += time;
        }
        avgUpdate /= updateQps * 1.0;
        for (Long time: this.deleteTime) {
            deleteQps++;
            avgDelete += time;
        }
        avgDelete /= deleteQps * 1.0;
        double totalQps = readQps + createQps + updateQps + deleteQps;
        System.out.println("Total runtime: " + totalRuntime);
        System.out.println("Read: " + readQps + " Create: " + createQps
                + " Update: " + updateQps + " Delete: " + deleteQps + " Total: " + totalQps);
        totalRuntime /= 1000;
        System.out.println("Total QPS: " + totalQps / totalRuntime + " avg query time: " +
                (totalQps * concurrency / (totalRuntime)));
        System.out.println("Read QPS: " + readQps / totalRuntime + " avg query time: " + avgRead);
        System.out.println("Create QPS: " + createQps / totalRuntime + " avg query time: " + avgCreate);
        System.out.println("Update QPS: " + updateQps / totalRuntime + " avg query time: " + avgUpdate);
        System.out.println("Delete QPS: " + deleteQps / totalRuntime + " avg query time: " + avgDelete);
    }

    private void cleanupExperiment(StorageService storageService) throws InterruptedException {
        System.out.println("Cleaning up remnants");
        CountDownLatch latch = new CountDownLatch(generatedPacket.size());
        for (StorageModel data: generatedPacket) {
            ListenableFuture<Packet> res = storageService.delete(data.getKey(), data.getVersion());
            res.addListener(latch::countDown, MoreExecutors.directExecutor());
        }
        latch.await();
        storageService.cleanup();
    }
    public static void main(String[] args) throws InterruptedException, ExecutionException {
        propertiesFile = args[0];
        ClientRunner clientRunner = new ClientRunner();
        System.out.println(clientRunner.getGreeting());
        StorageService storageService = new StorageService(clientRunner.clientID);
        storageService.initStorage();
        System.out.println("storage initialised");
        clientRunner.seedServer(storageService, clientRunner.createString());
        System.out.println("server seeded" + clientRunner.generatedPacket);
        final long startTime = System.currentTimeMillis();
        clientRunner.timerService();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            try {
                Thread.sleep(runtime * 1000L);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            clientRunner.experimentEnded = true;
            System.out.println("Experiment ended");
        });
        ExecutorService experimentExecutors = Executors.newFixedThreadPool(clientRunner.cpuCount);
        Set<Callable<Double>> callables = new HashSet<>();
        for (int i = 0; i < clientRunner.cpuCount; i++) {
            callables.add(() -> clientRunner.runExperiment(storageService));
        }
        List<Future<Double>> futures = experimentExecutors.invokeAll(callables);
        for (Future<Double> future: futures) {
            future.get();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Waiting for system to settle down");
        Thread.sleep(2000);
        double totalRuntime = endTime - startTime;
        clientRunner.printStatistics(totalRuntime);

        clientRunner.cleanupExperiment(storageService);
        executorService.shutdown();
        boolean status = executorService.awaitTermination(1000, TimeUnit.MICROSECONDS);
        if (!status)
            executorService.shutdownNow();
    }
}
