# High Performance Distributed Object Store [HPDOS]
## About
The HPDOS project is an attempt to optimise the storage stack in hyperconverged setups in recognition of recent advances in hardware technologies like SmartNICs, NVMe SSDs and persistent memories. 

Here we plan to take advantage of SmartNIC technologies more specifically SoC based NICs to speed up the storage stack.

## Getting started
The folder code contains the HPDOS server and client implementation. To use them clone this repo.

HPDOS uses `gRPC` system calls with `protocol buffers` as the data exchange standard. The project is managed using `Gradle` project manager. As a first step, install the system requirements listed at the end of this section.

### Compile
To compile the codebase run `./gradlew build` separately from the client and server root directory. Gradle should take care of installing and managing any third party libraries used.

### Execute
To execute the server and client run `./gradlew run` in separate terminals.

### Clean
The project build generated files can be cleaned by running `./gradlew clean`

### System Requirements
- Java | OpenJDK 14.0+
- Gradle
- Protocol Buffer / Protobuf