# Import packages
import requests
import os
from bs4 import BeautifulSoup
import sqlite3
from prettytable import PrettyTable

## NOTE : 
## 1. DO NOT CHANGE THE NAME OF ANY FUNCTION OR ANY ARGUMENT OR CLASS NAME. 
## 2. DO NOT CHANGE ANYTHING IN MAIN FUCNTION.
## 3. WRITE YOUR CODE INSIDE ### START CODE HERE ### and ### END CODE HERE ### ONLY
## 4. ANY DEVIATION IN THE NAMING CONVENTION, THE AUTOGRADER WILL MARK ZERO.

class CSE_Courses:
	conn = None
	cursor=None
	def __init__(self):
		"""
		Create the database CSE_Courses_DB and a table CSE_Courses
		"""
		### START CODE HERE ###
		path="./"
		global conn
		global cursor
		try:
			conn = sqlite3.connect(path+"CSE_Courses_DB.db")
			#print(sqlite3.version)
			cursor = conn.cursor()
			createTable='create table CSE_Courses("Course Code" TEXT,"Name" TEXT,"Instructor" TEXT)'
			cursor.execute(createTable)
		except Exception as e:
			#print(e)
			pass
			
		### END CODE HERE ###

	def get_courses(self,url):
		"""
		This method should scrap all the courses from the url and 
		returns list of lists where each inner list has [course code,name,instructor]
		of a course. 

		Arguments:
		url : url from which courses have to be scraped, string

		Returns:
		courses : courses scraped from the url : list of lists

		"""
		assert(isinstance(url,str))
		courses=list()
		### START CODE HERE ###
		req = requests.get(url)
		soup = BeautifulSoup(req.text, 'html.parser')
		rows=soup.find_all("tr", {"class": "greybodytr"})
		
		for row in rows:
			course =list()
			for data in row.children:
				for d in data:
					if  d.find("a") :
						if(d!=" "):
							course.append(d.strip(" "))
					else:
						if(d.text!="More Info"):
							if(d.text!=" "):
								course.append((d.text).strip(" "))
			courses.append(course)

		### END CODE HERE ###
		assert(isinstance(courses,list) and isinstance(courses[0],list))
		return courses

	def insert_data(self,courses):
		"""  
		This method will insert all the courses in the table CSE_Courses
		If you rerun your program, it will insert all the courses again 
		in the table, so if you want to delete the previously added course, 
		you may call delete_data() method from the main function.

		Arguments:
		courses : courses scrapped from the url : list of lists

		Returns:
		Nothing
		"""
		assert(isinstance(courses,list) and isinstance(courses[0],list))
		### START CODE HERE ###
		for course in courses:
			sql='insert into CSE_Courses ("Course Code",Name,Instructor) VALUES('+"'"+str(course[0])+"',"+"'"+str(course[1])+"',"+"'"+str(course[2])+"'"+")"
			#print(sql)
			cursor.execute(sql)
		conn.commit()
		### END CODE HERE ###

	def print_data(self):
		"""
		This method will print all the courses present in the table CSE_Courses
		in a tabular format [you may use tabulate or PrettyTable, 
		feel free to use any of your choice, but the output should be in tabular formmat]

		Arguments:
		Nothing

		Returns:
		Nothing
		"""
		### START CODE HERE ###
		x = PrettyTable()
		x.field_names = ["Course Code","Name","Instructor"]
		sql="select * from CSE_Courses"
		cursor.execute(sql)
		rows=cursor.fetchall()
		for row in rows:
			x.add_row(row)
		print(x)
		### END CODE HERE ###

	def delete_data(self,course_code=None):
		"""
		This method will delete the particular course if course_code is passed,
		otherwise if course code is not passed, it will delete all the records 
		from the table CSE_Courses

		Arguments:
		course_code : course code which has to be deleted from the table CSE_Courses : string
		
		Returns:
		Nothing
		"""
		if course_code:
			assert(isinstance(course_code,str))
		### START CODE HERE ###
		if course_code!=None:
			sql='delete from CSE_Courses where "Course Code"='+"'"+course_code+"'"
			cursor.execute(sql)
		else:
			sql="delete from CSE_Courses"
			cursor.execute(sql)
		conn.commit()
		### END CODE HERE ###

if __name__ == "__main__":
	url = "https://www.cse.iitb.ac.in/archive/page136"
	cse = CSE_Courses()

	courses = cse.get_courses(url)
	#cse.delete_data()
	cse.insert_data(courses)
	cse.print_data()
