import numpy as np
import random # for testing 
# ---- Task (a) -------
# Do as directed in function:
# 'my_list': a list of 25 integers
def avada_kedavra(my_list):
	# Create an array 'a0' from this list 'my_list'
	#my_integer=random.sample(range(1,101), 25) to test
	a0=np.array(my_list)
	# print a0
	print("a0 at beginning:\n{}".format(a0))

	# reshape a0 to create a 5X5 matrix a1
	a1=a0.reshape(5,5)
	# print a1
	print("a1 at the beginning:\n{}".format(a1))

	# now, change the central element of a1 to 0
	a1[2][2]=0
	# print a1
	print("a1 after change:\n{}".format(a1))

	# print a0
	print("a0 after changing a1:\n{}".format(a0))
	print("reshaping doesn't create a copy of array. It just returns another view. So, changing one changed the other")

	# make a copy of a1 and flatten it (call it a1cpy)
	a1cpy=a1.copy()
	# multiply each element of a1cpy by 0.7:
	a1cpy=np.round(np.multiply(a1cpy,0.7),2)
	# print a1cpy:
	print("a1cpy\n{}".format(a1cpy))

	# print a1:
	print("a1 after changing its copy:\n{}".format(a1))


# ---- Task (b) -------
# Do as directed in function:
# 'my_integer': an even integer
def incendio(my_integer):
	# create an array 'arng0' of shape (3,2) containing consecutive even numbers starting from 'my_integer', arranged along rows
	#my_integer=4
	arng0=np.arange(my_integer,my_integer+12,2)
	arng0=arng0.reshape(3,2)
	# print arng0
	print("arng0\n{}".format(arng0))

	# create another array 'arng1' of shape ((4,3)) containing consecutive numbers starting from 'my_integer' arranged along columns:
	arng1=np.arange(my_integer,my_integer+12,1)
	arng1=arng1.reshape(3,4)
	arng1=np.transpose(arng1)
	# print arng1
	print("arng1\n{}".format(arng1))

	# multiply transpose of arng0 with transpose of arng1 to get mult0:
	mult0=np.transpose(arng0).dot(np.transpose(arng1))

	# print mult0:
	print("mult0\n{}".format(mult0))

	# take min of mult0 along its rows and store it in v0:
	v0=mult0.min(axis=1)
	# print v0's shape:

	print("shape of v0: \n{}".format(v0.shape))

	# reshape v0 to make it a column vector:
	v0=v0.reshape(2,1)

	# subtract v0 from each column of mult0 and store it in base0:
	base0=mult0-v0
	# print base0
	print("base0\n{}".format(base0))

	# square all the elements present in base0
	base0=base0*base0
	# store the sum of all elements of base0 in ans
	ans=np.cumsum(base0)
	# print ans
	ans=np.sum(ans)
	print("ans : {}".format(ans))

# ---- Task (c) -------
# 'n': integer
# 'm': integer that divides n
# return type: int numpy Ndarray; dim: nxn
def alohomora(n, m):
    checkerboard = np.zeros((n,n), dtype=int)
    turn,count,row_turn,row_count = (0,0,0,0)
    for row in range(len(checkerboard)):
        if row_turn == 0 and row_count < m:
            for col in range(len(checkerboard[0])):
                if (turn == 0 and count < m):
                    checkerboard[row][col] = 1
                    count += 1
                    if (count >= m):
                        turn = 1
                        count = 0
                elif (turn == 1 and count <= m):
                    count += 1
                    if (count + 1 > m):
                        turn = 0
                        count = 0
            turn = 0
            row_count += 1
            if (row_count >= m):
                row_turn = 1
                row_count = 0
                turn = 1
                continue

        if row_turn == 1 and row_count < m:
            for col in range(len(checkerboard[0])):
                if (turn == 0 and count < m):
                    checkerboard[row][col] = 1
                    count += 1
                    if (count >= m):
                        turn = 1
                        count = 0
                elif (turn == 1 and count <= m):
                    count += 1
                    if (count + 1 > m):
                        turn = 0
                        count = 0
            turn = 1
            row_count += 1
            if (row_count >= m):
                row_turn = 0
                row_count = 0
                turn = 0
                continue

    return checkerboard


# ---- Task (d) -------
# 'arr': float Ndarray; dim: Nx3, 
# 'theta': float; 0≤theta<360 (in degrees)
# 'axis': str; axis ∈ {'X','Y','Z'}
# return type: float Ndarray; dim: Nx3
def expelliarmus(arr, theta, axis):
	angle = np.radians(-theta)
	c, s = np.cos(angle), np.sin(angle)
	rot_array_x = np.array([[1, 0, 0],
							[0, c, -s],
							[0, s, c]])
	rot_array_y = np.array([[c, 0, s],
							[0, 1, 0],
							[-s, 0, c]])
	rot_array_z = np.array([[c, -s, 0],
							[s, c, 0],
							[0, 0, 1]])
	if axis == 'X':
		res = np.dot(arr, rot_array_x)
		return (res.round(decimals=2))
	if axis == 'Y':
		res = np.dot(arr, rot_array_y)
		return (res.round(decimals=2))
	if axis == 'Z':
		res = np.dot(arr, rot_array_z)
		return (res.round(decimals=2))



# ---- Task (e) -------
# 'arr': float Ndarray; dim: MxN
# return type: float Ndarray; dim: MxN
def crucio(arr):
	#arr =np.array([[0 ,0, 0],[1, 1, 1],[2, -3, 5],[-4, 0, 3]])
	column_sums = arr.mean(axis=0)
	out=np.subtract(arr,column_sums)
	std=np.std(arr,axis=0)
	return (np.round(np.divide(out,std),2))
# ---- Task (f) -------
# 'arr': int 1-D array; dim: (n,)
# k: integer
# return type: int 1-D array; dim: (n+k-1,)
def leviosa(arr,k):
    arr=np.pad(arr,(0,k-1))
    cumm_ar=np.cumsum(arr)
    cumm_ar[k:]=cumm_ar[k:]- cumm_ar[:-k]
    return cumm_ar


# ---- Task (g) -------
# 'mat': int n-D array; dim: (m,n)
# k: integer
# return type: n-D integer array; dim: (m,k)
def accio(mat, k):
    return np.fliplr(np.argsort(mat))[:,:k]


