from django.db import models
from django.contrib.auth.models import User
import datetime
from django.utils import timezone

class Permission(models.Model):
    """This class is used to create the userspermission table  in database.Defines the permission of the user default permission is Student the admin can provide staff permission"""
    userId=models.ForeignKey(to=User, on_delete=models.CASCADE)
    """This is the foreign key pointing to Users table"""
    role=models.CharField(max_length=1,default="S") 
    """The roles  are Student(S) and Professor(P) default is student and admin allocates Professor role based on requests"""

class quiz(models.Model):
    """This class is used to create the quiz table in database.Contains information about the quiz time,length,code and instructor who has created it"""
    quizId=models.AutoField(primary_key=True)
    """The quizid to uniquely identiy the quiz (Primary key)"""
    startTime=models.TimeField()
    """Start Time of the quiz """
    date=models.DateField(default=datetime.date.today)
    """The Start date of quiz"""
    length=models.FloatField(max_length=10)
    """The duration of the quiz in minutes"""
    quizCode=models.CharField(max_length=100,default='Code') 
    """Random 6 Alhpa numeric characters assigned to each quiz"""
    quizDone=models.BooleanField(default=False)
    quizInfo=models.CharField(max_length=100,default="No Info Available")
    quizInstructor=models.ForeignKey(to=User, on_delete=models.CASCADE)
    """The instructor who created the quiz"""

    @property
    def end_datetime( self ):
        starttime = datetime.datetime.combine( self.date, self.startTime if self.startTime is not None else datetime.time.min )
        endtime = starttime + datetime.timedelta(minutes=self.length)
        return endtime

    def __str__(self):
        return str(self.quizId)

class Questions(models.Model):
    """ This class is used to create the Questions table in database.Contains info about the questions within a particular quiz and its attributes like socre and negative marks and correct answer"""
    question = models.TextField()
    """Question descirption"""
    option1 = models.CharField(max_length=100)
    """option 1 for question"""
    option2 = models.CharField(max_length=100)
    """option 2 for question"""
    option3 = models.CharField(max_length=100)
    """option 3 for question"""
    option4 = models.CharField(max_length=100)
    """option 4 for question"""
    answer = models.CharField(max_length=100)
    type=models.CharField(max_length=10,default=1)
    marks =models.IntegerField(default=1)
    negative = models.FloatField(max_length=10,default=0)
    explainations=models.TextField(max_length=1000,default='No Explaination Given')
    questionId=models.AutoField(primary_key=True,)
    """Unqiue question identifier Primary key"""
    quizCode =models.CharField(max_length=100,default='Code')
    """6 random alpha numeric characters for each quiz"""
    quizId=models.ForeignKey(quiz,to_field='quizId',on_delete=models.CASCADE)
    """Foreign key of quiz model"""
    
    def __str__(self):
        return str(self.questionId)
    class Meta:
        db_table="Questions"

class submission(models.Model):
    """ This class is used to create the Submission table in database.Contains info about each questions answer submitted by each student"""
    questionId=models.ForeignKey(Questions,to_field='questionId',on_delete=models.CASCADE)
    """Foreign key of question model"""
    option=models.CharField(max_length=100)
    """The option selected by the student"""
    studentId=models.ForeignKey(to=User, on_delete=models.CASCADE)
    """Foreign key of user model"""
    quizId=models.ForeignKey(quiz,to_field='quizId',on_delete=models.CASCADE)
    """Foreign key of quiz model"""

class cribs(models.Model):
    """ This class is used to create the cribs table in database.Contains cribs raised by students"""
    studentId=models.ForeignKey(to=User, on_delete=models.CASCADE)
    cribs=models.CharField(max_length=1000)
    """The cribs registered by the student for the given question"""
    quizId=models.ForeignKey(quiz,to_field='quizId',on_delete=models.CASCADE)
    """Foreign key of quiz model"""
    questionId=models.ForeignKey(Questions,to_field='questionId',on_delete=models.CASCADE)
    class Meta:
        db_table="cribs"


class result(models.Model):
    """This class is used to create the result table in database.Stores cumulative score by each student in each quiz"""
    studentId = models.ForeignKey(to=User, on_delete=models.CASCADE)
    quizId = models.ForeignKey(quiz, to_field='quizId', on_delete=models.CASCADE)
    """Foreign key of quiz model"""
    marks=models.IntegerField(default=0)
    """cumulative marks for each student"""


class log(models.Model):
    """This class is used to create the log table in database.stores the student activity information for monitoring the students"""
    quizId=models.ForeignKey(quiz,to_field='quizId',on_delete=models.CASCADE, default="")
    """Foreign key of quiz model"""
    studentId = models.ForeignKey(to=User, on_delete=models.CASCADE, default="")
    """Foreign key of user model"""
    logtime = models.DateTimeField(default=timezone.now) 
    """The time student last logged in"""
    fullscreen=models.CharField(max_length=20, default="")
    """Contains value to check whether the student has left fullscreen"""
    questions=models.CharField(max_length=20, default="")
    """Foreign key for questions model"""