# Generated by Django 3.1.2 on 2020-11-13 09:34

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Questions',
            fields=[
                ('question', models.TextField()),
                ('option1', models.CharField(max_length=100)),
                ('option2', models.CharField(max_length=100)),
                ('option3', models.CharField(max_length=100)),
                ('option4', models.CharField(max_length=100)),
                ('answer', models.CharField(max_length=100)),
                ('type', models.CharField(default=1, max_length=10)),
                ('marks', models.IntegerField(default=1)),
                ('negative', models.FloatField(default=0, max_length=10)),
                ('explainations', models.TextField(default='No Explaination Given', max_length=1000)),
                ('questionId', models.AutoField(primary_key=True, serialize=False)),
                ('quizCode', models.CharField(default='Code', max_length=100)),
            ],
            options={
                'db_table': 'Questions',
            },
        ),
        migrations.CreateModel(
            name='quiz',
            fields=[
                ('quizId', models.AutoField(primary_key=True, serialize=False)),
                ('startTime', models.TimeField()),
                ('date', models.DateField(default=datetime.date.today)),
                ('length', models.FloatField(max_length=10)),
                ('quizCode', models.CharField(default='Code', max_length=100)),
                ('quizDone', models.BooleanField(default=False)),
                ('quizInfo', models.CharField(default='No Info Available', max_length=100)),
                ('quizInstructor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='submission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('option', models.CharField(max_length=100)),
                ('questionId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='quiz.questions')),
                ('quizId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='quiz.quiz')),
                ('studentId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='result',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('marks', models.IntegerField(default=0, max_length=10)),
                ('quizId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='quiz.quiz')),
                ('studentId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='questions',
            name='quizId',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='quiz.quiz'),
        ),
        migrations.CreateModel(
            name='Permission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(default='S', max_length=1)),
                ('userId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='cribs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cribs', models.CharField(max_length=1000)),
                ('questionId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='quiz.questions')),
                ('quizId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='quiz.quiz')),
                ('studentId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'cribs',
            },
        ),
    ]
