from django.db import models
from django.contrib.auth.models import User
import datetime

class Permission(models.Model):
    userId=models.ForeignKey(to=User, on_delete=models.CASCADE)
    role=models.CharField(max_length=1,default="S")

class quiz(models.Model):
    quizId=models.AutoField(primary_key=True) #primary key

    #startTime=models.DateTimeField(auto_now_add=True,default=datetime.datetime.now) 
    startTime=models.TimeField()
    date=models.DateField(default=datetime.date.today)
    length=models.FloatField(max_length=10)
    quizCode=models.CharField(max_length=100,default='Code') ##quiz Code set by instructor
    quizDone=models.BooleanField(default=False)
    quizInfo=models.CharField(max_length=100,default="No Info Available")
    quizInstructor=models.ForeignKey(to=User, on_delete=models.CASCADE)

    @property
    def end_datetime( self ):
        starttime = datetime.datetime.combine( self.date, self.startTime if self.startTime is not None else datetime.time.min )
        endtime = starttime + datetime.timedelta(minutes=self.length)
        return endtime

    def __str__(self):
        return str(self.quizId)

class Questions(models.Model):
    question = models.TextField()
    option1 = models.CharField(max_length=100)
    option2 = models.CharField(max_length=100)
    option3 = models.CharField(max_length=100)
    option4 = models.CharField(max_length=100)
    answer = models.CharField(max_length=100)
    type=models.CharField(max_length=10,default=1)
    marks =models.IntegerField(default=1)
    negative = models.FloatField(max_length=10,default=0)
    explainations=models.TextField(max_length=1000,default='No Explaination Given')
    questionId=models.AutoField(primary_key=True,)
    quizCode =models.CharField(max_length=100,default='Code')
    quizId=models.ForeignKey(quiz,to_field='quizId',on_delete=models.CASCADE)#unique quiz identification
    
    def __str__(self):
        return str(self.questionId)
    class Meta:
        db_table="Questions"

class submission(models.Model):
    
    questionId=models.ForeignKey(Questions,to_field='questionId',on_delete=models.CASCADE)
    option=models.CharField(max_length=100)
    studentId=models.ForeignKey(to=User, on_delete=models.CASCADE)
    quizId=models.ForeignKey(quiz,to_field='quizId',on_delete=models.CASCADE)#unique quiz identification


class cribs(models.Model):
    studentId=models.CharField(max_length=100)
    cribs=models.CharField(max_length=1000)
    quizId=models.ForeignKey(quiz,to_field='quizId',on_delete=models.CASCADE)
    questionId=models.ForeignKey(Questions,to_field='questionId',on_delete=models.CASCADE)
    class Meta:
        db_table="cribs"


class result(models.Model):
    studentId = models.ForeignKey(to=User, on_delete=models.CASCADE)
    quizId = models.ForeignKey(quiz, to_field='quizId', on_delete=models.CASCADE)
    marks=models.IntegerField(max_length=10,default=0)