"use strict";

var current_question = 0;
var questions = document.getElementById('questions_area_wrapper').children;
questions[current_question].style.display = 'block';
var questions_len = parseInt(document.getElementById('question_count').value);
var selected_color = '#f4fa9c';
var deselected_color = '#ffffff';
 
    
function next_question () {
    var previous_question = current_question;
    current_question = ( current_question + 1 ) % questions_len;
    questions[previous_question].style.display = 'none';
    questions[current_question].style.display = 'block';
}

function prev_question () {
    var previous_question = current_question;
    current_question = ( current_question - 1 );
    if (current_question < 0) {
        current_question = questions_len - 1;
    }
    questions[previous_question].style.display = 'none';
    questions[current_question].style.display = 'block';
}

function goto_question(x) {
    if(typeof x == "number") {
        if(x>=0 && x<questions_len) {
            var previous_question = current_question;
            current_question = x;
            questions[previous_question].style.display = 'none';
            questions[current_question].style.display = 'block';
        }
    }
}

function set_option( question_id, option_id ) {
    if(typeof question_id == "number" && typeof option_id == "number") {
        if(question_id>=0 && question_id<questions_len && option_id>=0 && option_id<4) {
            var ans = document.getElementById('q'+question_id);
            if (ans.value == "NA") {
                ans.value = option_id;
                var cbox = document.getElementById("lbl_"+question_id+"_"+option_id);
                cbox.style.backgroundColor = selected_color;
            } else {
                if(option_id == ans.value) {
                    var obox = document.getElementById("lbl_"+question_id+"_"+ans.value);
                    obox.style.backgroundColor = deselected_color;
                    ans.value = "NA";
                } else {
                    var obox = document.getElementById("lbl_"+question_id+"_"+ans.value);
                    obox.style.backgroundColor = deselected_color;
                    ans.value = option_id;
                    var cbox = document.getElementById("lbl_"+question_id+"_"+option_id);
                    cbox.style.backgroundColor = selected_color;
                }
            }
        }
    }
}