"""QuizSystem URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from quiz.views import upload_file
from django.contrib import admin
from django.urls import path
from quiz import views as a
from django.conf import settings
from django.conf.urls import  url
from django.views.generic import TemplateView
from django.conf.urls.static import static
from django.urls import path,include

urlpatterns = [
    path('admin/', admin.site.urls),
            path('',a.student,name="student"),
            path('quiz/',a.index),
            path('submissions/',a.submissions),
            path('view_submission/',a.view_sub),
            path('save_ans/',a.save_ans,name="saveans"),
             path('save_cribs/',a.save_cribs,name="savecribs"),
            path('result/',a.result,name="result"),
            url(r'^upload/',TemplateView.as_view(template_name = 'upload.html')),
            path('uploaded/',a.upload_file,name="uploaded"),  path('sign_up/',a.sign_up,name="sign-up"), path('accounts/',include('django.contrib.auth.urls'))

]+ static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
