/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   circuitfinder.h
 * Author: sparsa
 *
 * Created on 2 October, 2017, 11:14 AM
 */

#ifndef CIRCUITFINDER_H
#define CIRCUITFINDER_H
#include <algorithm>
#include <iostream>
#include <list>
#include <vector>
using namespace std;
typedef enum {z,les,leq,que} relation;

//extern relation comparison[4][4];
extern relation addition[4][4];
typedef list<int> NodeList;
//void pairWiseTightestRelation (relation **graph, int V); //for tightening the matrix
typedef struct{bool A; bool B;} bool2;
void pairWiseTightestRelation (relation **graph, int V); //for tightening the matrix

class CircuitFinder // defining a circuit finder class
{
  vector<NodeList> AK; //this is the matrix representaion using node list
  vector<int> Stack; //a vector used a stack
  vector<bool> Blocked; // a boolean array to indicate which nodes are blocked and which are not
  vector<NodeList> B; // special node.
  int S;
    int N;
  void unblock(int U); //function to unblock the vertix U
  bool2 circuit(int V); // function to check if there is a circuit from note V
  bool cycleCheck(); //function to output the list of circuits in the graph
  relation **relmatrix;
public:
  CircuitFinder(relation **matrix,int N) :AK(N), Blocked(N), B(N)
    {
        this->N = N;
      relmatrix = new relation*[N];
      for(int i = 0; i < N; i++)
          relmatrix[i] = new relation[N];
      for (int I = 0; I<N; I ++)
      {
          for(int J = 0 ; J < N ; J++)
          {
              //if(matrix[I][J] == leq || matrix[I][J] == les || matrix[I][J] == que)
              //{
              relmatrix[I][J] = matrix[I][J]; // copying the matrix information in the class
	      if(matrix[I][J] != z)
                  AK[I].push_back(J+1); //every one is linked with every one because its a complete graph
              //}
          }
      }
    }
  ~CircuitFinder()
  {
      for(int i = 0;i < N; i++)
          delete[] relmatrix[i];
          delete[] relmatrix;
  }
  bool run(); //start the run
};




#endif /* CIRCUITFINDER_H */

