import numpy as np

class Confusion_Matrix():
	def __init__(self, classes):
		self.classes = classes
		self.matrix = np.zeros( (len(classes), len(classes)) )

	def update_matrix(self, predicted, target):

		zipped = zip(predicted, target)
		for i in zipped:
			self.matrix[i[0], i[1]] = self.matrix[i[0], i[1]] + 1

	def get_accuracy(self):

		tp = np.trace(self.matrix)
		tot = np.sum(self.matrix)

		return tp/tot

	def weighted_f1_score(self):
		row_sums = np.sum(self.matrix, axis=1)
		col_sums = np.sum(self.matrix, axis=0)
		f1_scores = []
		weighted_f1 = 0

		for i in range(self.matrix.shape[0]):
			if row_sums[i]==0 or col_sums[i]==0:
				f1_scores.append(0.0)
				continue
			precision = self.matrix[i,i]/row_sums[i]
			recall = self.matrix[i,i]/col_sums[i]
			if precision==0 or recall==0:
				f1_scores.append(0.0)
			else:
				f1 = (2.0*precision*recall)/(precision+recall)
				f1_scores.append(f1)

		for i in range(len(f1_scores)):
			weighted_f1 += f1_scores[i]*col_sums[i]
		return weighted_f1/np.sum(col_sums)
