# -*- coding: utf-8 -*-
#
# tensorpack documentation build configuration file, created by
# sphinx-quickstart on Sun Mar 27 01:41:24 2016.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys, os, re
import mock
import inspect

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath('../'))
os.environ['DOC_BUILDING'] = '1'
ON_RTD = (os.environ.get('READTHEDOCS') == 'True')


MOCK_MODULES = ['tabulate', 'h5py',
                'cv2', 'zmq', 'subprocess32', 'lmdb',
                'sklearn', 'sklearn.datasets',
                'scipy', 'scipy.misc', 'scipy.io',
                'tornado', 'tornado.concurrent',
                'horovod', 'horovod.tensorflow',
                'pyarrow', 'msgpack', 'msgpack_numpy',
                'functools32']
for mod_name in MOCK_MODULES:
    sys.modules[mod_name] = mock.Mock(name=mod_name)
sys.modules['cv2'].__version__ = '3.2.1'    # fake version

import tensorpack

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
needs_sphinx = '1.4'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.todo',
    'sphinx.ext.napoleon',
    #'sphinx.ext.autosectionlabel',
    #'sphinx.ext.coverage',
    'sphinx.ext.mathjax',
    'sphinx.ext.intersphinx',
    'sphinx.ext.viewcode',
]

# -- Configurations for plugins ------------
napoleon_google_docstring = True
napoleon_include_init_with_doc = True
napoleon_include_special_with_doc = True
napoleon_numpy_docstring = False
napoleon_use_rtype = False

if ON_RTD:
    intersphinx_timeout = 10
else:
    # skip this when building locally
    intersphinx_timeout = 0.1
intersphinx_mapping = {'python': ('https://docs.python.org/3.4', None)}
# -------------------------

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# to support markdown
from recommonmark.parser import CommonMarkParser
source_parsers = {
    '.md': CommonMarkParser,
}
# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
source_suffix = ['.rst', '.md']

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'tensorpack'
copyright = u'2015 - 2017, Yuxin Wu'
author = u'Yuxin Wu'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = tensorpack.__version__
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['build', 'README.md']

# The reST default role (used for this markup: `text`) to use for all
# documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = True
# 'tensorpack.' prefix was removed by js

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
modindex_common_prefix = ['tensorpack.']

# If true, keep warnings as "system message" paragraphs in the built documents.
keep_warnings = False

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
import sphinx_rtd_theme
html_theme = "sphinx_rtd_theme"
# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {}

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#html_logo = None

# The name of an image file (relative to this directory) to use as a favicon of
# the docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
#html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
html_domain_indices = True

# If false, no index is generated.
html_use_index = True

# If true, the index is split into individual pages for each letter.
html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = False

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
html_show_sphinx = False

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# avoid li fonts being larger
# TODO but li indices fonts are still larger
html_compact_lists = False

# Language to be used for generating the HTML full-text search index.
# Sphinx supports the following languages:
#   'da', 'de', 'en', 'es', 'fi', 'fr', 'hu', 'it', 'ja'
#   'nl', 'no', 'pt', 'ro', 'ru', 'sv', 'tr'
html_search_language = 'en'

# A dictionary with options for the search language support, empty by default.
# Now only 'ja' uses this config value
#html_search_options = {'type': 'default'}

# The name of a javascript file (relative to the configuration directory) that
# implements a search results scorer. If empty, the default will be used.
#html_search_scorer = 'scorer.js'

# Output file base name for HTML help builder.
htmlhelp_basename = 'tensorpackdoc'

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
# The paper size ('letterpaper' or 'a4paper').
#'papersize': 'letterpaper',

# The font size ('10pt', '11pt' or '12pt').
#'pointsize': '10pt',

# Additional stuff for the LaTeX preamble.
#'preamble': '',

# Latex figure (float) alignment
#'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'tensorpack.tex', u'tensorpack documentation',
     author, 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# If true, show page references after internal links.
#latex_show_pagerefs = False

# If true, show URL addresses after external links.
#latex_show_urls = False

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_domain_indices = True


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'tensorpack', u'tensorpack documentation',
     [author], 1)
]

# If true, show URL addresses after external links.
#man_show_urls = False


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'tensorpack', u'tensorpack documentation',
     author, 'tensorpack', 'One line description of project.',
     'Miscellaneous'),
]

# Documents to append as an appendix to all manuals.
#texinfo_appendices = []

# If false, no module index is generated.
#texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
#texinfo_no_detailmenu = False

suppress_warnings = ['image.nonlocal_uri']

#autodoc_member_order = 'bysource'

def process_signature(app, what, name, obj, options, signature,
            return_annotation):
    if signature:
        # replace Mock function names
        signature = re.sub('<Mock name=\'([^\']+)\'.*>', '\g<1>', signature)
        signature = re.sub('tensorflow', 'tf', signature)

        # add scope name to layer signatures:
        if hasattr(obj, 'use_scope') and hasattr(obj, 'symbolic_function'):
            if obj.use_scope:
                signature = signature[0] + 'scope_name, ' + signature[1:]
            elif obj.use_scope is None:
                signature = signature[0] + '[scope_name,] ' + signature[1:]
    # signature: arg list
    return signature, return_annotation

def autodoc_skip_member(app, what, name, obj, skip, options):
    # we hide something deliberately
    if getattr(obj, '__HIDE_SPHINX_DOC__', False):
        return True
    if name == '__init__':
        if obj.__doc__ and skip:
            # include_init_with_doc doesn't work well for decorated init
            # https://github.com/sphinx-doc/sphinx/issues/4258
            return False
    # hide deprecated stuff
    if name in [
        'MultiGPUTrainerBase',
        'get_predictors',
        'GaussianDeform',
        'dump_chkpt_vars',
        'DumpTensor',
        'StagingInputWrapper',
        'set_tower_func',
        'TryResumeTraining',
        'LeakyReLU',
        'PrefetchOnGPUs',

        'guided_relu', 'saliency_map', 'get_scalar_var', 'psnr',
        'prediction_incorrect', 'huber_loss',
        ]:
        return True
    if name in ['get_data', 'size', 'reset_state']:
        # skip these methods with empty docstring
        if not obj.__doc__ and inspect.isfunction(obj):
            # https://stackoverflow.com/questions/3589311/get-defining-class-of-unbound-method-object-in-python-3
            cls = getattr(inspect.getmodule(obj),
                          obj.__qualname__.split('.<locals>', 1)[0].rsplit('.', 1)[0])
            if issubclass(cls, tensorpack.DataFlow):
                return True
    return None

def url_resolver(url):
    if '.html' not in url:
        return "https://github.com/ppwwyyxx/tensorpack/blob/master/" + url
    else:
        if ON_RTD:
            return "http://tensorpack.readthedocs.io/en/latest/" + url
        else:
            return '/' + url

def setup(app):
    from recommonmark.transform import AutoStructify
    app.connect('autodoc-process-signature', process_signature)
    app.connect('autodoc-skip-member', autodoc_skip_member)
    app.add_config_value(
        'recommonmark_config',
        {'url_resolver': url_resolver,
         'auto_toc_tree_section': 'Contents',
         'enable_math': True,
         'enable_inline_math': True,
         'enable_eval_rst': True
        }, True)
    app.add_transform(AutoStructify)
