An issue has to be one of the following:
- [ ] Unexpected Problems / Potential Bugs
- [ ] Feature Requests
- [ ] Questions on Using/Understanding Tensorpack

## For any unexpected problems, __PLEASE ALWAYS INCLUDE__:
1. What you did:
  + If you're using examples:
    + What's the command you run:
    + Have you made any changes to code? Paste them if any:
  + If not, tell us what you did that may be relevant.
    But we may not investigate it if there is no reproducible code.
  + Better to paste what you did instead of describing them.
2. What you observed, including but not limited to the __entire__ logs.
  + Better to paste what you observed instead of describing them.
3. What you expected, if not obvious.
4. Your environment:
  + Python version.
  + TF version: `python -c 'import tensorflow as tf; print(tf.GIT_VERSION, tf.VERSION)'`.
  + Tensorpack version: `python -c 'import tensorpack; print(tensorpack.__version__)'`.
      You can install Tensorpack master by `pip install -U git+https://github.com/ppwwyyxx/tensorpack.git`.:
  + Hardware information, if relevant.

About efficiency issues, PLEASE first read http://tensorpack.readthedocs.io/en/latest/tutorial/performance-tuning.html

## Feature Requests:
+ You can implement a lot of features by extending Tensorpack
  (See http://tensorpack.readthedocs.io/en/latest/tutorial/index.html#extend-tensorpack).
  It does not have to be added to Tensorpack unless you have a good reason.
+ "Could you improve/implement an example/paper ?" 
  -- the answer is: we have no plans to do so. We don't take feature requests for
  examples or implement a paper for you. If you don't know how to do it, you may ask a usage question.

## Usage Questions:

+ Read the [tutorials](http://tensorpack.readthedocs.io/en/latest/tutorial/index.html#user-tutorials) first.
+ We answer "HOW to do X with Tensorpack" for a well-defined X.
  We also answer "HOW/WHY Tensorpack does X" for some X that Tensorpack or its examples are doing.
  We don't answer general machine learning questions,
  such as "why my training doesn't converge", "what networks to use" or "I don't understand the paper".

You can also use gitter (https://gitter.im/tensorpack/users) for more casual discussions.
