
# If you meet any unexpected problems when running the code, or want to report bugs, please STOP here. Go to the following link instead and fill out the information there:
https://github.com/tensorpack/tensorpack/issues/new?template=unexpected-problems---bugs.md


Otherwise, you can post here for:
1. Feature Requests:
  + Note that you can implement a lot of features by extending Tensorpack
   (See http://tensorpack.readthedocs.io/en/latest/tutorial/index.html#extend-tensorpack).
   It does not have to be added to Tensorpack unless you have a good reason.

2. Questions on Using/Understanding Tensorpack:
  + Your question is probably answered in [tutorials](http://tensorpack.readthedocs.io/en/latest/tutorial/index.html#user-tutorials). Read it first.
  + We answer "HOW to do X with Tensorpack" for a well-defined X.
    We also answer "HOW/WHY Tensorpack does X" for some X that Tensorpack or its examples are doing.

Some typical questions that we DO NOT answer:

+ "Could you improve/implement an example/paper ?" --
  We have no plans to do so. We don't consider feature
  requests for examples or implement a paper for you, unless it demonstrates 
  some Tensorpack features not yet demonstrated in the existing examples.
  If you don't know how to do something yourself, you may ask a usage question.
+ "The examples do not perform well after I change the models/dataset/parameters/etc."
  Tensorpack maintainers make sure the examples perform well without modification.
  But it's your job to make sure the model and parameters is suitable in your own situation.
  We do not help with such questions unless they appear to be a bug in tensorpack.
+ "Why my model doesn't work?", "I don't understand this paper you implement."
  We do not answer machine learning questions.
  

You can also use gitter (https://gitter.im/tensorpack/users) for more casual discussions.
