An issue has to be one of the following:
1. Unexpected Problems / Potential Bugs
2. Feature Requests
3. Usage Questions

For any unexpected problems, __PLEASE ALWAYS INCLUDE__:
1. What you did:
	+ If you're using examples:
		+ What's the command you run:
		+ Have you made any changes to code? Paste them if any:
	+ If not, tell us what you did that may be relevant.
		But we may not be able to resolve it if there is no reproducible code.
	+ Better to paste what you did instead of describing them.
2. What you observed, e.g. the entire log:
	+ Better to paste what you observed instead of describing them.
3. What you expected, if not obvious.
4. Your environment:
	+ Python version.
	+ TF version: `python -c 'import tensorflow as tf; print(tf.GIT_VERSION, tf.VERSION)'`.
	+ Tensorpack version: `python -c 'import tensorpack; print(tensorpack.__version__)'`.
      You can install Tensorpack master by `pip install -U git+https://github.com/ppwwyyxx/tensorpack.git`.:
5. About efficiency, PLEASE first read http://tensorpack.readthedocs.io/en/latest/tutorial/performance-tuning.html

Feature Requests:
+ You can implement a lot of features by extending tensorpack
	(See http://tensorpack.readthedocs.io/en/latest/tutorial/index.html#extend-tensorpack).
	It does not have to be added to tensorpack unless you have a good reason.
+ We don't take feature requests for implementing new papers.
  If you don't know how, ask it as a usage question.

Usage Questions:

+ Read the [tutorials](http://tensorpack.readthedocs.io/en/latest/tutorial/index.html#user-tutorials) first.
+ We answer "HOW to do X in tensorpack" for a well-defined X.
  We don't answer general machine learning questions,
  such as "what networks to use" or "I don't understand the paper".

You can also use gitter (https://gitter.im/tensorpack/users) for more casual discussions.
