
# tensorpack examples

Training examples with __reproducible__ and meaningful performance.

## Vision:
+ [An illustrative mnist example with explanation of the framework](mnist-convnet.py)
+ [A tiny SVHN ConvNet with 97.8% accuracy](svhn-digit-convnet.py)
+ [DoReFa-Net: binary / low-bitwidth CNN on ImageNet](DoReFa-Net)
+ [ResNet for ImageNet/Cifar10/SVHN](ResNet)
+ [Inception-BN with 71% accuracy](Inception/inception-bn.py)
+ [InceptionV3 with 74% accuracy (similar to the official code)](Inception/inceptionv3.py)
+ [Fully-convolutional Network for Holistically-Nested Edge Detection(HED)](HED)
+ [Spatial Transformer Networks on MNIST addition](SpatialTransformer)
+ Load a pretrained [AlexNet](load-alexnet.py) or [VGG16](load-vgg16.py) model.

## Reinforcement Learning:
+ [Deep Q-Network(DQN) variants on Atari games](Atari2600)
+ [Asynchronous Advantage Actor-Critic(A3C) with demos on OpenAI Gym](OpenAIGym)

## Unsupervised:
+ [Generative Adversarial Network(GAN) variants (DCGAN,Image2Image,InfoGAN)](examples/GAN)

## Speech / NLP:
+ [char-rnn for fun](char-rnn)
