#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#define _GNU_SOURCE
#include <fcntl.h>
#include <unistd.h>
#include <string.h> 
#include <stdatomic.h> 
#include "LRU.h"
#define ATOMIC_TEST_AND_SET  __atomic_test_and_set
#define CLEAR __atomic_clear
#define  MAX_SIZE 10


struct KV *array[MAX_SIZE];
struct queue *qu;
struct queue *last;




void remove_element_from_deque(char *key)
{
    queue *present = qu , *previous=NULL;
    while(present->next != NULL)
    {
        if(present->key == key)
        {
            if(previous == NULL)
                qu = qu->next;
            if(last == present)
                last = previous;
            if(previous)
                previous->next = present->next;
            free(present);
            return;
        }
        previous = present;
        present = present->next;
    }
}

void insert_into_queue(char *key)
{
    queue *temp = (queue *)malloc(sizeof(queue));
    temp->key = key;
    temp->next = NULL;
    if(qu == NULL)
    {
        qu = temp;
        last = temp;
    }
    else
    {
        last->next = temp;
        last = temp;
    }
}

int find_empty_location()
{
    for(int i=0;i<MAX_SIZE;i++)
    {
        if(array[i]->valid == FALSE)
            return i;
    }
}

int cache_del(char *key)
{
    for(int i=0;i<MAX_SIZE;i++)
    {
        if(strcmp(array[i]->key , key) == 0)
        {
            while(ATOMIC_TEST_AND_SET(&(array[i]->lock),1) == 1);
            remove_element_from_deque(key);
            array[i]->valid = FALSE;
            CLEAR(&(array[i]->lock),0);
            return 1;
        }
    }
    printf("Cache after DEL: \n");
    print_cache();
    return 0;
    //TODO remove key from file also
}

void cache_put(char *key, char *value)
{
    int indx=-1;
    for(int i=0;i<MAX_SIZE;i++)
    {
        if(array[i]->key!=NULL) {
            if(strcmp(array[i]->key , key) == 0)
            {
                indx = i;
                remove_element_from_deque(key);
                break;
            }
        }
    }
    printf("key is present at index: %d\n", indx);

    if(indx == -1)
    {
        indx = find_empty_location();
        // TODO should write to file if modified is true
        // replacment from cache
    }

    while(ATOMIC_TEST_AND_SET(&(array[indx]->lock),1) == 1);
    memcpy(array[indx]->key, key, KEY_SIZE);
    memcpy(array[indx]->value, value, VAL_SIZE);
    array[indx]->valid = TRUE;
    array[indx]->modified = TRUE;
    insert_into_queue(key);
    CLEAR(&(array[indx]->lock),0);
    printf("Cache after PUT: \n");
    print_cache();
}

int cache_get(char *key, char *value)
{
    for(int i=0;i<MAX_SIZE;i++)
    {
        if(strcmp(array[i]->key , key) == 0 && array[i]->valid)
        {
            while(ATOMIC_TEST_AND_SET(&(array[i]->lock),1) == 1);
            remove_element_from_deque(key);
            insert_into_queue(key);
            CLEAR(&(array[i]->lock),0);
            memcpy(value, array[i]->value, VAL_SIZE);
            return 1;
        }
    }
    return 0;
}

void init_cache() {
    for(int j=0;j<MAX_SIZE;j++)
    {
        array[j] = (KV *)malloc(sizeof(KV));
        array[j]->valid = FALSE;
        array[j]->lock = 0;
    }
}

void print_cache() {
    for(int j=0;j<MAX_SIZE;j++)
    {
        printf("[%d] (%s) : (%s)\n", array[j]->valid, array[j]->key, array[j]->value);
    }
}