#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#define _GNU_SOURCE
#include <fcntl.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/epoll.h>
#include <string.h> 
#include "LRU.h"
#include "KVMessageFormat.h"
#define MAX_EVENTS 10
#define DEBUG (0)

void gen_random(char *s, const int len) {
    static const char alphanum[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    for (int i = 0; i < len; ++i) {
        s[i] = alphanum[rand() % (sizeof(alphanum) - 1)];
    }

    s[len] = 0;
}

void *worker(void *args) {
    struct epoll_event ev,events[MAX_EVENTS];
    struct epoll_event socketEvent;
    socketEvent.events=EPOLLIN;

    int read_pipe, conn_sock, nfds, i;
    int epollfd;
    int newfd;
    int status;


    // Generate name for each thread for debugging
    char *name = (char *) malloc(5*sizeof(char));
    gen_random(name, 5);
    if DEBUG printf("[%s] Thread started!\n", name);
    
    epollfd = epoll_create1(0);
    while (epollfd == -1) {
        epollfd = epoll_create1(0);
    }

    /* Add the pipe which we get from main thread */
    read_pipe = ((int *) args)[0];   
    ev.events = EPOLLIN;
    ev.data.fd = read_pipe;
    if (epoll_ctl(epollfd, EPOLL_CTL_ADD, read_pipe, &ev) == -1) {
        perror("epoll_ctl: read_pipe");
        exit(EXIT_FAILURE);
    }
    //if DEBUG printf("[%s] Added read pipe to epoll fd set!\n", name);
    while (1) {

        if DEBUG printf("[%s] waiting for epoll event!\n", name);
        nfds = epoll_wait(epollfd, events, MAX_EVENTS, -1);
        if (nfds == -1) {
            perror("epoll_wait");
            exit(EXIT_FAILURE);
        }
        if DEBUG printf("[%s] %d events !\n", name, nfds);
        for ( i= 0; i < nfds; ++i ) {
            if (events[i].data.fd == read_pipe) {
                /*  if we get a request from main thread to add new client */
                read(read_pipe, &newfd, sizeof(newfd));
              
                if DEBUG printf("[%s][EVENT] New Client assigned by main thread fd:%d!\n", name, newfd);
                ev.data.fd=newfd;
                ev.events = EPOLLIN | EPOLLRDHUP;
                if (epoll_ctl(epollfd, EPOLL_CTL_ADD, newfd,  &ev) == -1) {
                    perror("epoll_ctl: read_pipe");
                    exit(EXIT_FAILURE);
                }

               
            } else {
                /*  if we get a request from client (GET, PUSH, DEL) */
                int flag = events[i].events;

                if DEBUG printf("[%s][EVENT] flag set: %d\n", name, flag);
                if (flag & EPOLLRDHUP) {
                    /* Connection was closed. */
                    if DEBUG printf("[%s][EVENT][EPOLLRDHUP] \n", name);
                    epoll_ctl( epollfd, EPOLL_CTL_DEL, events[i].data.fd , NULL );
                    close(events[i].data.fd);
                    continue; 
                }

                if (flag & EPOLLIN) {
                    /* Parse the actual message from client */
                    struct message *requestMessage= malloc(sizeof(struct message));
                    int readlength=read(events[i].data.fd  , requestMessage, sizeof(struct message)); 
                    //printf("[Message Received from client] (%d, %s, %s)\n",requestMessage->status,requestMessage->key,requestMessage->value);               
                    
                    if DEBUG printf("[%s][EVENT][EPOLLIN] \n", name);
                    switch(requestMessage->status) {
                        case STATUS_GET:
                            if DEBUG printf("[%s] GET \n", name);
                            status = cache_get(requestMessage->key, requestMessage->value);
                            if(status) {
                                requestMessage->status = 200;
                            } else {
                                requestMessage->status = 240;
                            }
                            break;
                        case STATUS_PUT:
                            if DEBUG printf("[%s] PUT \n", name);
                            cache_put(requestMessage->key, requestMessage->value);
                            requestMessage->status = 200;
                            break;
                        case STATUS_DEL:
                            if DEBUG printf("[%s] DEL \n", name);
                            status = cache_del(requestMessage->key);
                            if(status == 0) {
                                requestMessage->status = 240;
                            } else {
                                requestMessage->status = 200;
                            }
                            break;
                    }
                    

                    write(events[i].data.fd, requestMessage, sizeof(struct message));
                    free(requestMessage);
                }                                 
               
            }
        }
        
    }

    free(name);
    
}


int main (int argc, int argv) {

    int i;
    int next_thread_to_assign = 0;                                   
    pthread_t *worker_threads;                             
    int pool_thread_size = 1;                       // TODO: get pool thread size from config file
    int sockfd, newsockfd, portno, clilen, n;
    struct sockaddr_in serv_addr, cli_addr; 

    //int *pipes = (int*) malloc(pool_thread_size * 2 * sizeof(pipes));
    int pipes[1][2];                                // TODO: initialize pipes dynamically

    worker_threads = malloc(pool_thread_size * sizeof(pthread_t));
    for( i=0; i < pool_thread_size; i++ ) {
        pipe(pipes[i]);
        pthread_create( &worker_threads[i], NULL, worker, &pipes[i]);
    }

    sockfd = socket(AF_INET, SOCK_STREAM, 0); 
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(1);
    }
    memset(&serv_addr, 0, sizeof(serv_addr));
    portno = 8000;
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(portno);
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    int option =1;
    setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &option, sizeof(option));
    if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        perror("ERROR on binding");
        exit(1);
    }
    
    listen(sockfd, 5);
    clilen = sizeof(cli_addr);

    init_cache();

    while(1) {

        newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
        if (newsockfd < 0) 
            perror("ERROR on accept");

        write(pipes[next_thread_to_assign][1], &newsockfd, sizeof(newsockfd));
        next_thread_to_assign = (next_thread_to_assign+1) % pool_thread_size;
    } 

    return 0;
}
