/*

PA4 instructions:
Each request and response will be 513 Byte messages. First byte of the message will be some
status code, and this status code will uniquely identify different requests and responses. Next
256 Bytes will be key, you can use padding if the actual key is not 256B. The last 256 Bytes of
the message will be value, again you can use padding if value is not 256B. In case of GET and
DEL requests where no value is required you can only consider the first 257B of the request
message.
DEL: 3
Status Codes for response message
Success: 200
Error: 400 (with the appropriate error message)
Reasons for error could be GET key not found, DEL key not found etc.

*/
#define STATUS_GET 1
#define STATUS_DEL 2
#define STATUS_PUT 3

struct message{
    unsigned char status;
    char key[256];
    char value[256];
};
