#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h> 
#include <netdb.h> 
#include <unistd.h>
#include "KVClientLibrary.h"

// to print a message
void printMessage(struct message *requestMessage)
{
    printf("[Message Generated]\n[[Status:%d]\n[Key:%s]\n[Value:%s]]\n",requestMessage->status,requestMessage->key,requestMessage->value);
    return ;
}
int  get(int sockfd,char* key,char *value,char *error)
{
    if(key==NULL)
    {
        printf("Invalid PARAM to get\n");
        return -1;
    }
    struct message *request=malloc(sizeof(struct message));
    request->status=1;//status code for get
    memcpy(request->key,key,256); //copied the complete key passed as parameter
    explicit_bzero(request->value,256*sizeof(char));//null value to to the request->value field
    struct message *reply=malloc(sizeof(struct message));
    write(sockfd, request, sizeof(struct message)); //passing to server and waiting for response
    read(sockfd,reply,sizeof(struct message));
    int status=reply->status;
    if(status==400)
    {
        memcpy(error,reply->key,256*sizeof(char)); //copying the error in the key field for an failed get

    }
    else
    {
        memcpy(value,reply->value,256*sizeof(char));
    }
    
    free(request);
    free(reply);
    return status; //return reply->key


}
int del(int sockfd,char *key,char *error)
{
    if(key==NULL)
    {
        printf("Invalid PARAM to del\n");
        return -1;
    }
    struct message *request=malloc(sizeof(struct message));
    request->status=2;//status code for delete
    memcpy(request->key,key,256); //copied the complete key passed as parameter
    explicit_bzero(request->value,256*sizeof(char));//null value to to the request->value field

    struct message *reply=malloc(sizeof(struct message));
    write(sockfd, request, sizeof(struct message)); //passing to server and waiting for response to the del request
    read(sockfd,reply,sizeof(struct message));
    int status=(int)reply->status;
    if(status==400)
    {
        memcpy(error,reply->key,256*sizeof(char)); //copying the error in the key field for an failed del
    }
    free(request);
    free(reply);
    return status; //return reply->key

}
int put(int sockfd,char *key,char *value,char *error)
{
    if(key==NULL)
    {
        printf("Invalid PARAM to del\n");
        return -1;
    }
    struct message *request=malloc(sizeof(struct message));
    request->status=3;//status code for delete
    memcpy(request->key,key,256); //copied the complete key passed as parameter
    memcpy(request->value,value,256); //copied the complete key passed as parameter
    struct message *reply=malloc(sizeof(struct message));
    write(sockfd, request, sizeof(struct message)); //passing to server and waiting for response to the del request
    read(sockfd,reply,sizeof(struct message));
    int status=reply->status;
    if(status==400)
    {
        memcpy(error,reply->key,256*sizeof(char)); //copying the error in the key field for an failed del
    }
    else
    {
        //printMessage(reply);
    }
    
    free(request);
    free(reply);
    return status; //return reply->key

}

