
# Create your views here.
from django.shortcuts import render,redirect
from django.contrib.auth import authenticate,login
from django.views import generic
from .forms import UserForm
from .models import File
from django.views import generic
from django.views.generic.edit import CreateView,UpdateView,DeleteView
from django.views.generic import View
from django.contrib.auth.forms import UserCreationForm,AuthenticationForm
from .models import File,User
from django.http import JsonResponse
import json
from django.views.decorators.csrf import csrf_exempt

def index(request):
    usernam = None
    if request.user.is_authenticated:
        usernam = request.user.username
    all_files = File.objects.filter(username=usernam)
    context={'all_files': all_files}
    return render(request,'myapp/index.html',context)
@csrf_exempt
def register(request):
    if request.method == 'POST':
        form = UserCreationForm(request.POST)

        if form.is_valid():
            form.save()
            usernam = form.cleaned_data['username']
            password = form.cleaned_data['password1']
            p=User(username=usernam,sync=0)
            p.save()
            user = authenticate(username=usernam,password=password)
            login(request,user)
            return redirect('home')

    else:
        form = UserCreationForm()

    context = {'form' : form}
    return render(request,'registration/register.html',context)

@csrf_exempt
def linuxlogin(request):
    if request.method == 'POST':
        details=json.loads(request.body.decode('utf-8'))
        usr_name=details['username']
        passw=details['password']
        if authenticate(username=usr_name,password=passw):
            return JsonResponse({'yes':'yes'})
        else:
            return JsonResponse({'yes':'no'})
@csrf_exempt
def upload(request):
    if request.method == 'POST':
        file1=request.FILES['file']
        cont=file1.read()
        file2=request.FILES['det']
        details=json.load(file2)
        usr_name = details['username']
        passw = details['password']
        if authenticate(username=usr_name, password=passw):
            data = cont
            name=file1.name
            p=File(username=usr_name,file_name=name,file_content=data)
            p.save()
            return JsonResponse({'yes':'yes'})
        else:
            return JsonResponse({'yes':'no'})
def toclient(request):

    if request.method == 'POST':
        usernam = None
        if request.user.is_authenticated:
            usernam = request.user.username
            all_files = File.objects.filter(username=usernam)
            for r in all_files:
                data=r.file_content
                return HttpResponse(data, content_type='application/octet-stream')




class IndexView(generic.ListView):
    template_name='myapp/index.html'

    def get_queryset(self):
        if user.is_authenticated:
            nam=user.username
        return File.objects.filter(username=nam)

class FileCreate(CreateView):
    model=File
    fields=['user_name','password','file_name','sync']







