package com.sudogeeks.talking_reminder;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.speech.tts.TextToSpeech;

import java.util.Locale;

/**\brief Class for Text to speech service
 * This class is extending the tts module service to speak up the reminder text
 */
public class ReadReminderTextService extends Service implements TextToSpeech.OnInitListener, TextToSpeech.OnUtteranceCompletedListener {
    private TextToSpeech mTts;
    private String spokenText;

    /**
     * Overrides onCreate , this is the good place to set spokentext.
     */
    @Override

    public void onCreate() {
        mTts = new TextToSpeech(this, this);
        // This is a good place to set spokenText
        // spokenText="raushan raushan raushan raushan";
    }

    /**
     * Overrides OnStartCommand of service class , this is used to get reminder text which will be spoken.
     * @param intent
     * @param flags
     * @param startId
     * @return
     */
    @Override

    public int onStartCommand(Intent intent, int flags, int startId) {
        spokenText = intent.getStringExtra("MyTitle");
        return START_STICKY;
    }

    /**
     * This method overrides onInit and this is calling TTS object to speak up the spoken text.
     * @param status
     */
    @Override

    public void onInit(int status) {
        if (status == TextToSpeech.SUCCESS) {
            int result = mTts.setLanguage(Locale.US);
            if (result != TextToSpeech.LANG_MISSING_DATA && result != TextToSpeech.LANG_NOT_SUPPORTED) {

                mTts.speak(spokenText, TextToSpeech.QUEUE_ADD, null);

            }
        }
    }

    @Override
    public void onUtteranceCompleted(String uttId) {
        stopSelf();
    }

    @Override
    public void onDestroy() {
        if (mTts != null) {
            mTts.stop();
            mTts.shutdown();
        }
        super.onDestroy();
    }

    @Override
    public IBinder onBind(Intent arg0) {
        return null;
    }
}