package com.sudogeeks.talking_reminder;


import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.speech.tts.TextToSpeech;

import androidx.core.app.NotificationCompat;

/** \brief Class to implement notification
 * This class is for implementing notification popup at alarm time
 */
public class NotificationHelper extends ContextWrapper {
    public static final String channelID = "channelID";
    public static final String channelName = "Channel Name";
    String mTitle;
    PendingIntent mClick;
    private NotificationManager mManager;
    private TextToSpeech t1;

    /**
     * Constructor for NotificationHelper class
     * @param base
     * @param intent
     */
    public NotificationHelper(Context base, Intent intent) {
        super(base);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            createChannel();
        }
        int mReceivedID = Integer.parseInt(intent.getStringExtra(ReminderEditActivity.EXTRA_REMINDER_ID));


        ReminderDatabase rb = new ReminderDatabase(base);
        ReminderDO reminderDO = rb.getReminder(mReceivedID);
        mTitle = reminderDO.getTitle();

        // Create intent to open ReminderEditActivity on notification click
        Intent editIntent = new Intent(base, ReminderEditActivity.class);
        editIntent.putExtra(ReminderEditActivity.EXTRA_REMINDER_ID, Integer.toString(mReceivedID));
        mClick = PendingIntent.getActivity(base, mReceivedID, editIntent, PendingIntent.FLAG_UPDATE_CURRENT);

    }

    @TargetApi(Build.VERSION_CODES.O)
    private void createChannel() {
        NotificationChannel channel = new NotificationChannel(channelID, channelName, NotificationManager.IMPORTANCE_HIGH);

        getManager().createNotificationChannel(channel);
    }

    public NotificationManager getManager() {
        if (mManager == null) {
            mManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        }

        return mManager;
    }

    /**
     * This method build notificationCompat having various setting of notification likeicon, content,priority,etc..
     * @return NotificationCompat.Builder for the notification
     */
    public NotificationCompat.Builder getChannelNotification() {


        //t1.speak(mTitle, TextToSpeech.QUEUE_FLUSH, null);

        //   t1.synthesizeToFile(mTitle, null, "/SDCARD/speak1.wav");
        //Uri alarmSound = Uri.parse(ContentResolver.SCHEME_ANDROID_RESOURCE + "://" + getPackageName() + "/raw/sample");

        return new NotificationCompat.Builder(getApplicationContext(), channelID)
                .setLargeIcon(BitmapFactory.decodeResource(getApplicationContext().getResources(), R.mipmap.ic_launcher))
                .setSmallIcon(R.drawable.ic_alarm_on_white)
                .setContentTitle(getApplicationContext().getResources().getString(R.string.app_name))
                .setTicker(mTitle)
                .setContentText(mTitle)
                //.setSound(RingtoneManager.getDefaultUri(RingtoneManager.TYPE_ALARM))
                // .setSound(Uri.fromFile(new File("SDCARD/s1.mp3")))
                //.setSound(null)
                .setPriority(NotificationManager.IMPORTANCE_HIGH)
                .setContentIntent(mClick)
                .setAutoCancel(true)
                .setOnlyAlertOnce(true);
    }

    public TextToSpeech getTextToSpeech() {
        return t1;
    }
}

//function