# WIRELESS X



## Installation Setup

    1. (Optional if already present) Install below packages (python development):

            $ sudo apt-get install python3-tk python3-dev


    2. Install opencv, autopy, pynput, pyfakewebcam library:

            $ sudo pip3 install opencv-python
            $ sudo pip3 install autopy
            $ sudo pip3 install pynput
            $ sudo pip3 install pyfakewebcam


    3. FFmpeg and v4l2loopback Setup (for virtual device creation and video frames rendering):

        a. Install FFmpeg by typing following command:

                $ sudo apt install ffmpeg


        b. Install v4l2loopback-dkms v4l2loopback-utils module:

                $ sudo apt install v4l2loopback-dkms v4l2loopback-utils
                $ sudo modprobe -r v4l2loopback
                $ sudo depmod -a


## Running the application (Strictly follow the below order inorder to run it successfully):

    1. Creating virtual device (for webcam) and server On Desktop / Laptop side:

        a. Create device using below 2 commands:
                $ sudo modprobe v4l2loopback devices=1 video_nr=20 card_label='Wireless-X Camera' exclusive_caps=1


            Check if your virtual device is created
                $ ls /dev | grep -P '^video\d+$'

            (Optional if already done earlier):
                $ sudo depmod -a


        b. run python file in the directory using below command:
                $ python3 Wireless-X_server.py
            
            If no errors encountered, below output should be displayed on terminal:

                    ---------Wireless-X Server------
                    Camera stream port: 9998
                    Keyboard and Mouse Listening port: 6666

                    

    2. Application Installation and Setup on Android Smartphone:

        a. Install the Wireless-X apk on Android smartphone and give required permissions.

        b. Now enter the IP address of the Laptop/ Desktop on which the server is hosted. You can type the below command in terminal to get host IP:
                $ ifconfig 
        
        c. Click on Test Button to test the connection of smartphone with the server. If failed, Recheck if you have entered correct IP address of Laptop/ Desktop (on 
            which the server is running).

        d. After successfull connection, you would be able to control mouse, keyboard of laptop and use smartphones camera as webcam for the laptop/Desktop.

        e. Now you would be able to use this virtual webcam device on chrome for video conferincing. (Tested on chrome for MS Teams and Google Meet).

        f. (Optional) Inorder to test if camera frames are received to the Laptop/ Desktop, use the below command while (Note: camera option should be turned on in the 
            Wireless-X apk on Android):
                $ ffplay /dev/video20 


## IMPORTANT: Make sure you have a virtual device created before running the Wireless-X_server.py.




#### *Extra (Inorder to remove v42loopback devices, use below command):
            
            $ sudo modprobe -r v4l2loopback




## Steps for Debugging (If python code doesn't run after above commands):

    1. Check if your virtual device is created

        $ ls /dev | grep -P '^video\d+$'
        OR
        $ v4l2-ctl --list-devices    # TO List the virtual devices in detail

            Output should look somewhat like this:

                Wireless-X Camera (platform:v4l2loopback-000):
                    /dev/video20

                Webcam C170: Webcam C170 (usb-0000:00:1a.0-1.2):
                    /dev/video0
                    /dev/video1


    2. Inorder to test if virtual device is working:
        Copy the sample code from  https://github.com/jremmons/pyfakewebcam page and save it as python file and run it.
            
            $ python3 demo.py

        If everything worked correctly, no error should be displayed and terminal should be blank.
        Now, Open another terminal and test if virtual device output is being display by entering below command:
            
            $ ffplay /dev/video20
        
        Note: ffplay





## References

Opencv references:

    https://cmsdk.com/java/android-opencv-tcp-video-streaming.html


v4l2loopback references:

    https://github.com/jremmons/pyfakewebcam
    https://github.com/jremmons/pyfakewebcam/issues/5
    https://github.com/umlaeute/v4l2loopback#DKMS


Android:
    https://stackoverflow.com/questions/23024831/android-shared-preferences-for-creating-one-time-activity-example


