/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opencv.android.CameraGLRendererBase;
import org.opencv.android.CameraGLSurfaceView;

@TargetApi(value=21)
public class Camera2Renderer
extends CameraGLRendererBase {
    protected final String LOGTAG = "Camera2Renderer";
    private CameraDevice mCameraDevice;
    private CameraCaptureSession mCaptureSession;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private String mCameraID;
    private Size mPreviewSize = new Size(-1, -1);
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private final Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            Camera2Renderer.this.mCameraDevice = cameraDevice;
            Camera2Renderer.this.mCameraOpenCloseLock.release();
            Camera2Renderer.this.createCameraPreviewSession();
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            Camera2Renderer.this.mCameraDevice = null;
            Camera2Renderer.this.mCameraOpenCloseLock.release();
        }

        public void onError(CameraDevice cameraDevice, int error) {
            cameraDevice.close();
            Camera2Renderer.this.mCameraDevice = null;
            Camera2Renderer.this.mCameraOpenCloseLock.release();
        }
    };

    Camera2Renderer(CameraGLSurfaceView view) {
        super(view);
    }

    @Override
    protected void doStart() {
        Log.d((String)"Camera2Renderer", (String)"doStart");
        this.startBackgroundThread();
        super.doStart();
    }

    @Override
    protected void doStop() {
        Log.d((String)"Camera2Renderer", (String)"doStop");
        super.doStop();
        this.stopBackgroundThread();
    }

    boolean cacPreviewSize(int width, int height) {
        Log.i((String)"Camera2Renderer", (String)("cacPreviewSize: " + width + "x" + height));
        if (this.mCameraID == null) {
            Log.e((String)"Camera2Renderer", (String)"Camera isn't initialized!");
            return false;
        }
        CameraManager manager = (CameraManager)this.mView.getContext().getSystemService("camera");
        try {
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(this.mCameraID);
            StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            int bestWidth = 0;
            int bestHeight = 0;
            float aspect = (float)width / (float)height;
            for (Size psize : map.getOutputSizes(SurfaceTexture.class)) {
                int w = psize.getWidth();
                int h = psize.getHeight();
                Log.d((String)"Camera2Renderer", (String)("trying size: " + w + "x" + h));
                if (width < w || height < h || bestWidth > w || bestHeight > h || !((double)Math.abs(aspect - (float)w / (float)h) < 0.2)) continue;
                bestWidth = w;
                bestHeight = h;
            }
            Log.i((String)"Camera2Renderer", (String)("best size: " + bestWidth + "x" + bestHeight));
            if (bestWidth == 0 || bestHeight == 0 || this.mPreviewSize.getWidth() == bestWidth && this.mPreviewSize.getHeight() == bestHeight) {
                return false;
            }
            this.mPreviewSize = new Size(bestWidth, bestHeight);
            return true;
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2Renderer", (String)"cacPreviewSize - Camera Access Exception");
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"Camera2Renderer", (String)"cacPreviewSize - Illegal Argument Exception");
        }
        catch (SecurityException e) {
            Log.e((String)"Camera2Renderer", (String)"cacPreviewSize - Security Exception");
        }
        return false;
    }

    @Override
    protected void openCamera(int id) {
        Log.i((String)"Camera2Renderer", (String)"openCamera");
        CameraManager manager = (CameraManager)this.mView.getContext().getSystemService("camera");
        try {
            String[] camList = manager.getCameraIdList();
            if (camList.length == 0) {
                Log.e((String)"Camera2Renderer", (String)"Error: camera isn't detected.");
                return;
            }
            if (id == -1) {
                this.mCameraID = camList[0];
            } else {
                for (String cameraID : camList) {
                    CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraID);
                    if ((id != 99 || (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != 1) && (id != 98 || (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != 0)) continue;
                    this.mCameraID = cameraID;
                    break;
                }
            }
            if (this.mCameraID != null) {
                if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("Time out waiting to lock camera opening.");
                }
                Log.i((String)"Camera2Renderer", (String)("Opening camera: " + this.mCameraID));
                manager.openCamera(this.mCameraID, this.mStateCallback, this.mBackgroundHandler);
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2Renderer", (String)"OpenCamera - Camera Access Exception");
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"Camera2Renderer", (String)"OpenCamera - Illegal Argument Exception");
        }
        catch (SecurityException e) {
            Log.e((String)"Camera2Renderer", (String)"OpenCamera - Security Exception");
        }
        catch (InterruptedException e) {
            Log.e((String)"Camera2Renderer", (String)"OpenCamera - Interrupted Exception");
        }
    }

    @Override
    protected void closeCamera() {
        Log.i((String)"Camera2Renderer", (String)"closeCamera");
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void createCameraPreviewSession() {
        int w = this.mPreviewSize.getWidth();
        int h = this.mPreviewSize.getHeight();
        Log.i((String)"Camera2Renderer", (String)("createCameraPreviewSession(" + w + "x" + h + ")"));
        if (w < 0 || h < 0) {
            return;
        }
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null == this.mCameraDevice) {
                this.mCameraOpenCloseLock.release();
                Log.e((String)"Camera2Renderer", (String)"createCameraPreviewSession: camera isn't opened");
                return;
            }
            if (null != this.mCaptureSession) {
                this.mCameraOpenCloseLock.release();
                Log.e((String)"Camera2Renderer", (String)"createCameraPreviewSession: mCaptureSession is already started");
                return;
            }
            if (null == this.mSTexture) {
                this.mCameraOpenCloseLock.release();
                Log.e((String)"Camera2Renderer", (String)"createCameraPreviewSession: preview SurfaceTexture is null");
                return;
            }
            this.mSTexture.setDefaultBufferSize(w, h);
            Surface surface = new Surface(this.mSTexture);
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.addTarget(surface);
            this.mCameraDevice.createCaptureSession(Arrays.asList(surface), new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    Camera2Renderer.this.mCaptureSession = cameraCaptureSession;
                    try {
                        Camera2Renderer.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        Camera2Renderer.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                        Camera2Renderer.this.mCaptureSession.setRepeatingRequest(Camera2Renderer.this.mPreviewRequestBuilder.build(), null, Camera2Renderer.this.mBackgroundHandler);
                        Log.i((String)"Camera2Renderer", (String)"CameraPreviewSession has been started");
                    }
                    catch (CameraAccessException e) {
                        Log.e((String)"Camera2Renderer", (String)"createCaptureSession failed");
                    }
                    Camera2Renderer.this.mCameraOpenCloseLock.release();
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    Log.e((String)"Camera2Renderer", (String)"createCameraPreviewSession failed");
                    Camera2Renderer.this.mCameraOpenCloseLock.release();
                }
            }, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2Renderer", (String)"createCameraPreviewSession");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while createCameraPreviewSession", e);
        }
    }

    private void startBackgroundThread() {
        Log.i((String)"Camera2Renderer", (String)"startBackgroundThread");
        this.stopBackgroundThread();
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        Log.i((String)"Camera2Renderer", (String)"stopBackgroundThread");
        if (this.mBackgroundThread == null) {
            return;
        }
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            Log.e((String)"Camera2Renderer", (String)"stopBackgroundThread");
        }
    }

    @Override
    protected void setCameraPreviewSize(int width, int height) {
        Log.i((String)"Camera2Renderer", (String)("setCameraPreviewSize(" + width + "x" + height + ")"));
        if (this.mMaxCameraWidth > 0 && this.mMaxCameraWidth < width) {
            width = this.mMaxCameraWidth;
        }
        if (this.mMaxCameraHeight > 0 && this.mMaxCameraHeight < height) {
            height = this.mMaxCameraHeight;
        }
        try {
            this.mCameraOpenCloseLock.acquire();
            boolean needReconfig = this.cacPreviewSize(width, height);
            this.mCameraWidth = this.mPreviewSize.getWidth();
            this.mCameraHeight = this.mPreviewSize.getHeight();
            if (!needReconfig) {
                this.mCameraOpenCloseLock.release();
                return;
            }
            if (null != this.mCaptureSession) {
                Log.d((String)"Camera2Renderer", (String)"closing existing previewSession");
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            this.mCameraOpenCloseLock.release();
            this.createCameraPreviewSession();
        }
        catch (InterruptedException e) {
            this.mCameraOpenCloseLock.release();
            throw new RuntimeException("Interrupted while setCameraPreviewSize.", e);
        }
    }
}

