/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.content.Context;
import android.content.res.TypedArray;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import org.opencv.R;
import org.opencv.android.Camera2Renderer;
import org.opencv.android.CameraGLRendererBase;
import org.opencv.android.CameraRenderer;

public class CameraGLSurfaceView
extends GLSurfaceView {
    private static final String LOGTAG = "CameraGLSurfaceView";
    private CameraTextureListener mTexListener;
    private final CameraGLRendererBase mRenderer;

    public CameraGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray styledAttrs = this.getContext().obtainStyledAttributes(attrs, R.styleable.CameraBridgeViewBase);
        int cameraIndex = styledAttrs.getInt(R.styleable.CameraBridgeViewBase_camera_id, -1);
        styledAttrs.recycle();
        this.mRenderer = Build.VERSION.SDK_INT >= 21 ? new Camera2Renderer(this) : new CameraRenderer(this);
        this.setCameraIndex(cameraIndex);
        this.setEGLContextClientVersion(2);
        this.setRenderer(this.mRenderer);
        this.setRenderMode(0);
    }

    public void setCameraTextureListener(CameraTextureListener texListener) {
        this.mTexListener = texListener;
    }

    public CameraTextureListener getCameraTextureListener() {
        return this.mTexListener;
    }

    public void setCameraIndex(int cameraIndex) {
        this.mRenderer.setCameraIndex(cameraIndex);
    }

    public void setMaxCameraPreviewSize(int maxWidth, int maxHeight) {
        this.mRenderer.setMaxCameraPreviewSize(maxWidth, maxHeight);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        super.surfaceCreated(holder);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mRenderer.mHaveSurface = false;
        super.surfaceDestroyed(holder);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        super.surfaceChanged(holder, format, w, h);
    }

    public void onResume() {
        Log.i((String)LOGTAG, (String)"onResume");
        super.onResume();
        this.mRenderer.onResume();
    }

    public void onPause() {
        Log.i((String)LOGTAG, (String)"onPause");
        this.mRenderer.onPause();
        super.onPause();
    }

    public void enableView() {
        this.mRenderer.enableView();
    }

    public void disableView() {
        this.mRenderer.disableView();
    }

    public static interface CameraTextureListener {
        public void onCameraViewStarted(int var1, int var2);

        public void onCameraViewStopped();

        public boolean onCameraTexture(int var1, int var2, int var3, int var4);
    }
}

