/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.opencv.android.CameraGLSurfaceView;

@TargetApi(value=15)
public abstract class CameraGLRendererBase
implements GLSurfaceView.Renderer,
SurfaceTexture.OnFrameAvailableListener {
    protected final String LOGTAG = "CameraGLRendererBase";
    private final String vss = "attribute vec2 vPosition;\nattribute vec2 vTexCoord;\nvarying vec2 texCoord;\nvoid main() {\n  texCoord = vTexCoord;\n  gl_Position = vec4 ( vPosition.x, vPosition.y, 0.0, 1.0 );\n}";
    private final String fssOES = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying vec2 texCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture,texCoord);\n}";
    private final String fss2D = "precision mediump float;\nuniform sampler2D sTexture;\nvarying vec2 texCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture,texCoord);\n}";
    private final float[] vertices = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    private final float[] texCoordOES = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    private final float[] texCoord2D = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private final int[] texCamera = new int[]{0};
    private final int[] texFBO = new int[]{0};
    private final int[] texDraw = new int[]{0};
    private final int[] FBO = new int[]{0};
    private int progOES = -1;
    private int prog2D = -1;
    private int vPosOES;
    private int vTCOES;
    private int vPos2D;
    private int vTC2D;
    private final FloatBuffer vert;
    private final FloatBuffer texOES;
    private final FloatBuffer tex2D;
    protected int mCameraWidth = -1;
    protected int mCameraHeight = -1;
    protected int mFBOWidth = -1;
    protected int mFBOHeight = -1;
    protected int mMaxCameraWidth = -1;
    protected int mMaxCameraHeight = -1;
    protected int mCameraIndex = -1;
    protected SurfaceTexture mSTexture;
    protected boolean mHaveSurface = false;
    protected boolean mHaveFBO = false;
    protected boolean mUpdateST = false;
    protected boolean mEnabled = true;
    protected boolean mIsStarted = false;
    protected CameraGLSurfaceView mView;

    protected abstract void openCamera(int var1);

    protected abstract void closeCamera();

    protected abstract void setCameraPreviewSize(int var1, int var2);

    public CameraGLRendererBase(CameraGLSurfaceView view) {
        this.mView = view;
        int bytes = this.vertices.length * 32 / 8;
        this.vert = ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.texOES = ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.tex2D = ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.vert.put(this.vertices).position(0);
        this.texOES.put(this.texCoordOES).position(0);
        this.tex2D.put(this.texCoord2D).position(0);
    }

    public synchronized void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.mUpdateST = true;
        this.mView.requestRender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        if (!this.mHaveFBO) {
            return;
        }
        CameraGLRendererBase cameraGLRendererBase = this;
        synchronized (cameraGLRendererBase) {
            if (this.mUpdateST) {
                this.mSTexture.updateTexImage();
                this.mUpdateST = false;
            }
            GLES20.glClear((int)16384);
            CameraGLSurfaceView.CameraTextureListener texListener = this.mView.getCameraTextureListener();
            if (texListener != null) {
                this.drawTex(this.texCamera[0], true, this.FBO[0]);
                boolean modified = texListener.onCameraTexture(this.texFBO[0], this.texDraw[0], this.mCameraWidth, this.mCameraHeight);
                if (modified) {
                    this.drawTex(this.texDraw[0], false, 0);
                } else {
                    this.drawTex(this.texFBO[0], false, 0);
                }
            } else {
                Log.d((String)"CameraGLRendererBase", (String)"texCamera(OES) -> screen");
                this.drawTex(this.texCamera[0], true, 0);
            }
        }
    }

    public void onSurfaceChanged(GL10 gl, int surfaceWidth, int surfaceHeight) {
        Log.i((String)"CameraGLRendererBase", (String)("onSurfaceChanged(" + surfaceWidth + "x" + surfaceHeight + ")"));
        this.mHaveSurface = true;
        this.updateState();
        this.setPreviewSize(surfaceWidth, surfaceHeight);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Log.i((String)"CameraGLRendererBase", (String)"onSurfaceCreated");
        this.initShaders();
    }

    private void initShaders() {
        String strGLVersion = GLES20.glGetString((int)7938);
        if (strGLVersion != null) {
            Log.i((String)"CameraGLRendererBase", (String)("OpenGL ES version: " + strGLVersion));
        }
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.progOES = CameraGLRendererBase.loadShader("attribute vec2 vPosition;\nattribute vec2 vTexCoord;\nvarying vec2 texCoord;\nvoid main() {\n  texCoord = vTexCoord;\n  gl_Position = vec4 ( vPosition.x, vPosition.y, 0.0, 1.0 );\n}", "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying vec2 texCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture,texCoord);\n}");
        this.vPosOES = GLES20.glGetAttribLocation((int)this.progOES, (String)"vPosition");
        this.vTCOES = GLES20.glGetAttribLocation((int)this.progOES, (String)"vTexCoord");
        GLES20.glEnableVertexAttribArray((int)this.vPosOES);
        GLES20.glEnableVertexAttribArray((int)this.vTCOES);
        this.prog2D = CameraGLRendererBase.loadShader("attribute vec2 vPosition;\nattribute vec2 vTexCoord;\nvarying vec2 texCoord;\nvoid main() {\n  texCoord = vTexCoord;\n  gl_Position = vec4 ( vPosition.x, vPosition.y, 0.0, 1.0 );\n}", "precision mediump float;\nuniform sampler2D sTexture;\nvarying vec2 texCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture,texCoord);\n}");
        this.vPos2D = GLES20.glGetAttribLocation((int)this.prog2D, (String)"vPosition");
        this.vTC2D = GLES20.glGetAttribLocation((int)this.prog2D, (String)"vTexCoord");
        GLES20.glEnableVertexAttribArray((int)this.vPos2D);
        GLES20.glEnableVertexAttribArray((int)this.vTC2D);
    }

    private void initSurfaceTexture() {
        Log.d((String)"CameraGLRendererBase", (String)"initSurfaceTexture");
        this.deleteSurfaceTexture();
        this.initTexOES(this.texCamera);
        this.mSTexture = new SurfaceTexture(this.texCamera[0]);
        this.mSTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
    }

    private void deleteSurfaceTexture() {
        Log.d((String)"CameraGLRendererBase", (String)"deleteSurfaceTexture");
        if (this.mSTexture != null) {
            this.mSTexture.release();
            this.mSTexture = null;
            CameraGLRendererBase.deleteTex(this.texCamera);
        }
    }

    private void initTexOES(int[] tex) {
        if (tex.length == 1) {
            GLES20.glGenTextures((int)1, (int[])tex, (int)0);
            GLES20.glBindTexture((int)36197, (int)tex[0]);
            GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10241, (int)9728);
            GLES20.glTexParameteri((int)36197, (int)10240, (int)9728);
        }
    }

    private static void deleteTex(int[] tex) {
        if (tex.length == 1) {
            GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
        }
    }

    private static int loadShader(String vss, String fss) {
        Log.d((String)"CameraGLRendererBase", (String)"loadShader");
        int vshader = GLES20.glCreateShader((int)35633);
        GLES20.glShaderSource((int)vshader, (String)vss);
        GLES20.glCompileShader((int)vshader);
        int[] status = new int[1];
        GLES20.glGetShaderiv((int)vshader, (int)35713, (int[])status, (int)0);
        if (status[0] == 0) {
            Log.e((String)"CameraGLRendererBase", (String)("Could not compile vertex shader: " + GLES20.glGetShaderInfoLog((int)vshader)));
            GLES20.glDeleteShader((int)vshader);
            vshader = 0;
            return 0;
        }
        int fshader = GLES20.glCreateShader((int)35632);
        GLES20.glShaderSource((int)fshader, (String)fss);
        GLES20.glCompileShader((int)fshader);
        GLES20.glGetShaderiv((int)fshader, (int)35713, (int[])status, (int)0);
        if (status[0] == 0) {
            Log.e((String)"CameraGLRendererBase", (String)("Could not compile fragment shader:" + GLES20.glGetShaderInfoLog((int)fshader)));
            GLES20.glDeleteShader((int)vshader);
            GLES20.glDeleteShader((int)fshader);
            fshader = 0;
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)program, (int)vshader);
        GLES20.glAttachShader((int)program, (int)fshader);
        GLES20.glLinkProgram((int)program);
        GLES20.glDeleteShader((int)vshader);
        GLES20.glDeleteShader((int)fshader);
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])status, (int)0);
        if (status[0] == 0) {
            Log.e((String)"CameraGLRendererBase", (String)("Could not link shader program: " + GLES20.glGetProgramInfoLog((int)program)));
            program = 0;
            return 0;
        }
        GLES20.glValidateProgram((int)program);
        GLES20.glGetProgramiv((int)program, (int)35715, (int[])status, (int)0);
        if (status[0] == 0) {
            Log.e((String)"CameraGLRendererBase", (String)("Shader program validation error: " + GLES20.glGetProgramInfoLog((int)program)));
            GLES20.glDeleteProgram((int)program);
            program = 0;
            return 0;
        }
        Log.d((String)"CameraGLRendererBase", (String)"Shader program is built OK");
        return program;
    }

    private void deleteFBO() {
        Log.d((String)"CameraGLRendererBase", (String)("deleteFBO(" + this.mFBOWidth + "x" + this.mFBOHeight + ")"));
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glDeleteFramebuffers((int)1, (int[])this.FBO, (int)0);
        CameraGLRendererBase.deleteTex(this.texFBO);
        CameraGLRendererBase.deleteTex(this.texDraw);
        this.mFBOHeight = 0;
        this.mFBOWidth = 0;
    }

    private void initFBO(int width, int height) {
        Log.d((String)"CameraGLRendererBase", (String)("initFBO(" + width + "x" + height + ")"));
        this.deleteFBO();
        GLES20.glGenTextures((int)1, (int[])this.texDraw, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.texDraw[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
        GLES20.glGenTextures((int)1, (int[])this.texFBO, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.texFBO[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
        GLES20.glGenFramebuffers((int)1, (int[])this.FBO, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)this.FBO[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texFBO[0], (int)0);
        Log.d((String)"CameraGLRendererBase", (String)("initFBO error status: " + GLES20.glGetError()));
        int FBOstatus = GLES20.glCheckFramebufferStatus((int)36160);
        if (FBOstatus != 36053) {
            Log.e((String)"CameraGLRendererBase", (String)("initFBO failed, status: " + FBOstatus));
        }
        this.mFBOWidth = width;
        this.mFBOHeight = height;
    }

    private void drawTex(int tex, boolean isOES, int fbo) {
        GLES20.glBindFramebuffer((int)36160, (int)fbo);
        if (fbo == 0) {
            GLES20.glViewport((int)0, (int)0, (int)this.mView.getWidth(), (int)this.mView.getHeight());
        } else {
            GLES20.glViewport((int)0, (int)0, (int)this.mFBOWidth, (int)this.mFBOHeight);
        }
        GLES20.glClear((int)16384);
        if (isOES) {
            GLES20.glUseProgram((int)this.progOES);
            GLES20.glVertexAttribPointer((int)this.vPosOES, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vert);
            GLES20.glVertexAttribPointer((int)this.vTCOES, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.texOES);
        } else {
            GLES20.glUseProgram((int)this.prog2D);
            GLES20.glVertexAttribPointer((int)this.vPos2D, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vert);
            GLES20.glVertexAttribPointer((int)this.vTC2D, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.tex2D);
        }
        GLES20.glActiveTexture((int)33984);
        if (isOES) {
            GLES20.glBindTexture((int)36197, (int)tex);
            GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.progOES, (String)"sTexture"), (int)0);
        } else {
            GLES20.glBindTexture((int)3553, (int)tex);
            GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.prog2D, (String)"sTexture"), (int)0);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glFlush();
    }

    public synchronized void enableView() {
        Log.d((String)"CameraGLRendererBase", (String)"enableView");
        this.mEnabled = true;
        this.updateState();
    }

    public synchronized void disableView() {
        Log.d((String)"CameraGLRendererBase", (String)"disableView");
        this.mEnabled = false;
        this.updateState();
    }

    protected void updateState() {
        boolean willStart;
        Log.d((String)"CameraGLRendererBase", (String)"updateState");
        Log.d((String)"CameraGLRendererBase", (String)("mEnabled=" + this.mEnabled + ", mHaveSurface=" + this.mHaveSurface));
        boolean bl = willStart = this.mEnabled && this.mHaveSurface && this.mView.getVisibility() == 0;
        if (willStart != this.mIsStarted) {
            if (willStart) {
                this.doStart();
            } else {
                this.doStop();
            }
        } else {
            Log.d((String)"CameraGLRendererBase", (String)"keeping State unchanged");
        }
        Log.d((String)"CameraGLRendererBase", (String)"updateState end");
    }

    protected synchronized void doStart() {
        Log.d((String)"CameraGLRendererBase", (String)"doStart");
        this.initSurfaceTexture();
        this.openCamera(this.mCameraIndex);
        this.mIsStarted = true;
        if (this.mCameraWidth > 0 && this.mCameraHeight > 0) {
            this.setPreviewSize(this.mCameraWidth, this.mCameraHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        Log.d((String)"CameraGLRendererBase", (String)"doStop");
        CameraGLRendererBase cameraGLRendererBase = this;
        synchronized (cameraGLRendererBase) {
            this.mUpdateST = false;
            this.mIsStarted = false;
            this.mHaveFBO = false;
            this.closeCamera();
            this.deleteSurfaceTexture();
        }
        CameraGLSurfaceView.CameraTextureListener listener = this.mView.getCameraTextureListener();
        if (listener != null) {
            listener.onCameraViewStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPreviewSize(int width, int height) {
        CameraGLRendererBase cameraGLRendererBase = this;
        synchronized (cameraGLRendererBase) {
            this.mHaveFBO = false;
            this.mCameraWidth = width;
            this.mCameraHeight = height;
            this.setCameraPreviewSize(width, height);
            this.initFBO(this.mCameraWidth, this.mCameraHeight);
            this.mHaveFBO = true;
        }
        CameraGLSurfaceView.CameraTextureListener listener = this.mView.getCameraTextureListener();
        if (listener != null) {
            listener.onCameraViewStarted(this.mCameraWidth, this.mCameraHeight);
        }
    }

    public void setCameraIndex(int cameraIndex) {
        this.disableView();
        this.mCameraIndex = cameraIndex;
        this.enableView();
    }

    public void setMaxCameraPreviewSize(int maxWidth, int maxHeight) {
        this.disableView();
        this.mMaxCameraWidth = maxWidth;
        this.mMaxCameraHeight = maxHeight;
        this.enableView();
    }

    public void onResume() {
        Log.i((String)"CameraGLRendererBase", (String)"onResume");
    }

    public void onPause() {
        Log.i((String)"CameraGLRendererBase", (String)"onPause");
        this.mHaveSurface = false;
        this.updateState();
        this.mCameraHeight = -1;
        this.mCameraWidth = -1;
    }
}

