#include <stdio.h>
#include "server.h"
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <pthread.h>

void initVals(char *ip, char *portNo, int *nThreads) {
    FILE *ptr = fopen("config.txt", "r");
    fscanf(ptr, "%s\n%s\n%d\n", ip, portNo, nThreads);
    fclose(ptr);
}

void *respondToClient(void *args) {
    int clientFd = *((int *)args);
    while(1) {
        // printf("reading for client %d\n", clientFd);
        // char buffer[513];
        char *buffer = (char *)malloc(513*sizeof(char));
        int len = read(clientFd, buffer, 513);
        buffer[len] = '\0';
        
        char key[100], value[100];
        memset(key, '\0', 100);
        memset(value, '\0', 100);

        char todo = buffer[0];
        // key: first non-zero till byte 257
        int i;
        if(todo!='4'){
            for(i=1; buffer[i]=='0'; i++);
            // printf("I: %d %c\n", i, buffer[i]);
            printf("key length: %d\n", 257-i);
            memcpy(key, buffer+i, 257-i);

            // value: first non-zero till byte 513
            for(i=257; buffer[i]=='0'; i++);
            printf("value length: %d\n", 513-i);
            memcpy(value, buffer+i, 513-i);
        }

        switch(todo) {
            case '1':
                printf("GET recvd\n");
                printf("Key: %s\n", key);
                write(clientFd, "Get returns\0", 12);
                break;
            case '2':
                printf("PUT recvd\n");
                printf("Key: %s\n", key);
                printf("Value: %s\n", value);
                write(clientFd, "Put returns\0", 12);
                break;
            case '3':
                printf("DELETE recvd\n");
                printf("Key: %s\n", key);
                write(clientFd, "Delete returns\0", 15);
                break;
            case '4':
                printf("Connection terminated\n");
                write(clientFd, "Connection terminated\0", 22);
                return NULL;
                // break;
        }

        // printf("%s\n", buffer);
        // write(clientFd, "Client response\0", 16);
        // if (todo=='4')
        // {
            // return NULL;
        // }
    }
}

int acceptConnections(char *addr, char *portNo, int nThreads) {
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    pthread_t clientThreads[nThreads];
    int clientNo = 0;

    struct addrinfo hints, *result;
    memset(&hints, 0, sizeof(struct addrinfo));
    hints.ai_family = AF_INET;
    hints.ai_socktype = SOCK_STREAM;
    hints.ai_flags = AI_PASSIVE;

    int s = getaddrinfo(addr, portNo, &hints, &result);
    if(s != 0) {
        fprintf(stderr, "getaddrinfo: %s\n", gai_strerror(s));
        return -1;
    }

    int b = bind(sockfd, result->ai_addr, result->ai_addrlen);
    if(b != 0) {
        printf("Binding error\n");
        return -1;
    }

    int l = listen(sockfd, nThreads);
    if(l != 0) {
        printf("Error while listening...\n");
        return -1;
    }

    printf("Waiting for connection...\n");
    while(1) {
        int clientFd = accept(sockfd, NULL, NULL);
        printf("Connected to client with fd: %d\n", clientFd);
        clientNo++; // shared variables hence we need conditional variable
        int fid = fork();
        if(fid==0) {
            // create thread
            int *cfd = &clientFd;
            pthread_create(&clientThreads[clientNo], NULL, respondToClient, (void *)cfd);

        } else {
            // manage threads
        }

    }

    return 0;
}

int main(int argc, char **argv) {
    printf("Server is running...\n");
    char ip[20], portNo[10];
    int nThreads;
    initVals(ip, portNo, &nThreads);
    printf("Ip address: %s\n", ip);
    printf("portno: %s\n", portNo);
    printf("no of threads: %d\n", nThreads);
    acceptConnections(ip, portNo, nThreads);

    return 0;
}
