#include <stdio.h>
#include "client.h"
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>


void padding(char* str, char* key, int padTo) {
    int n = strlen(str);
    for(int i = n + 1; i < padTo; i++) {
        key[i] = ' ';
    }
}

int connectToServer(char *addr, char *portNo) {
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    struct addrinfo hints, *result;

    memset(&hints, 0, sizeof(struct addrinfo));
    hints.ai_family = AF_INET;
    hints.ai_socktype = SOCK_STREAM;

    // getaddrinfo return getaddr objects by searching using the provided hints, name, service
    int s = getaddrinfo(addr, portNo, &hints, &result);
    if(s != 0) {
        fprintf(stderr, "getaddrinfo: %s\n", gai_strerror(s));
        return -1;
    }
    connect(sockfd, result->ai_addr, result->ai_addrlen);
    cout << GET("ABC", sockfd) << endl;

    return 0;
}

int GET(char* key, int sockfd) {
    int padTo = 513;
    char *buffer = (char *)malloc(padTo + 1);
    strncpy(&buffer[1], key, strlen(key));
    padding(key, buffer, padTo);
    buffer[padTo] = '\0';
    buffer[0] = '1';
    write(sockfd, buffer, strlen(buffer));
    char recvBuffer[padTo];
    int len = read(sockfd, recvBuffer, padTo);
    if(recvBuffer[0] == 200) {
        printf("Value : %s\n", recvBuffer[1]);
        return 1;
    }
    else 
        return 0;
}

int PUT(char* key, char* value, int sockfd) {
    int padTo = 257;
    char *buffer = (char *)malloc(2 * padTo - 1);
    strncpy(&buffer[1], key, strlen(key));
    padding(key, buffer, padTo);
    strncpy(&buffer[padTo], value, strlen(value));
    padding(value, &buffer[padTo], padTo);
    buffer[0] = '2';
    write(sockfd, buffer, strlen(buffer));
    char recvBuffer[padTo];
    int len = read(sockfd, recvBuffer, padTo);
    if(recvBuffer[0] == 200) {
        printf("Success\n");
        return 1;
    }
    else {
        printf("Failure\n");
        return 0;
    }
}

int DEL(char* key, int sockfd) {
    int padTo = 513;
    char *buffer = (char *)malloc(padTo + 1);
    strncpy(&buffer[1], key, strlen(key));
    padding(key, buffer, padTo);
    buffer[padTo] = '\0';
    buffer[0] = '3';
    write(sockfd, buffer, strlen(buffer));
    char recvBuffer[padTo];
    int len = read(sockfd, recvBuffer, padTo);
    if(recvBuffer[0] == 200) {
        printf("Value : %s\n", recvBuffer[1]);
        return 1;
    }
    else 
        return 0;
}

int main(int  argc, char **argv) {
    printf("IP = %s, Port = %s\n", argv[1], argv[2]);
    connectToServer(argv[1], argv[2]);
    return 0;
}
