#include <stdio.h>
#include "client.h"
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

int connectToServer(char *addr, char *portNo) {
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    struct addrinfo hints, *result;

    memset(&hints, 0, sizeof(struct addrinfo));
    hints.ai_family = AF_INET;
    hints.ai_socktype = SOCK_STREAM;

    // getaddrinfo return getaddr objects by searching using the provided hints, name, service
    int s = getaddrinfo(addr, portNo, &hints, &result);
    if(s != 0) {
        fprintf(stderr, "getaddrinfo: %s\n", gai_strerror(s));
        return -1;
    }

    connect(sockfd, result->ai_addr, result->ai_addrlen);

    sendToServer(sockfd);

    return 0;
}

void sendToServer(int sockfd) {
    printf("Enter the index no to choose an option...\n");
    printf("------OPTIONS------\n1. GET\n2. PUT\n3. DELETE\n4. EXIT\n");
    int choice;
    char *buffer = (char *)malloc(513*sizeof(char));
    while(1) {
        printf("Enter choice: :");
        scanf("%d", &choice);
        char key[100], value[100];
        switch(choice) {
            case 1:
                printf("Key: ");
                scanf("%s", key);
                GET(key, buffer);
                break;
            case 2:
                printf("Key: ");
                scanf("%s", key);
                printf("Value: ");
                scanf("%s", value);
                PUT(key, value, buffer);
                break;
            case 3:
                printf("Key: ");
                scanf("%s", key);
                DELETE(key, buffer);
                break;
            case 4:
                printf("Requested for connection termination\n");
                terminateConnection(buffer);
                // return NULL;
                break;
        }

        // printf("buffer : %s\n", buffer);
        write(sockfd, buffer, strlen(buffer));
        char recvBuffer[1000];
        int len = read(sockfd, recvBuffer, 999);
        recvBuffer[len] = '\0';
        printf("%s\n", recvBuffer);
        if(choice==4)
        {
            return NULL;
        }
    }
    // char buffer[100];
    // while(fgets(buffer, 100, stdin) != NULL) {
    //     write(sockfd, buffer, strlen(buffer));
    //     char recvBuffer[1000];
    //     int len = read(sockfd, recvBuffer, 999);
    //     recvBuffer[len] = '\0';
    //     printf("%s\n", recvBuffer);
    // }
}

int GET(char* key, char *request) {
    printf("GET called!\n");
    // char request[513];
    memset(request, '0', 513);
    request[0] = '1';
    // memcpy(request+1, key, strlen(key));
    memcpy(request+257-strlen(key), key, strlen(key));
    // printf("request : %s\n", request);
}

int PUT(char* key, char* value, char *request) {
    printf("PUT called!\n");
    // char request[513];
    memset(request, '0', 513);
    request[0] = '2';
    // memcpy(request+1, key, strlen(key));
    memcpy(request+257-strlen(key), key, strlen(key));
    memcpy(request+513-strlen(value), value, strlen(value));
    printf("key at index: %ld\n", 257-strlen(key));
    printf("value at index: %ld\n", 513-strlen(value));
}
int DELETE(char* key, char *request) {
    // char request[513];
    printf("DELETE called!\n");
    memset(request, '0', 513);
    request[0] = '3';
    // memcpy(request+1, key, strlen(key));
    memcpy(request+257-strlen(key), key, strlen(key));
    // printf("%s\n", request);
}

void terminateConnection(char *request) {
    //char request[513];
    // printf("Termination function called\n");
    memset(request, '0', 513);
    request[0]='4';
    request[512]='\0';
}

int main(int  argc, char **argv) {
    printf("IP = %s, Port = %s\n", argv[1], argv[2]);
    // PUT("100", "200");
    connectToServer(argv[1], argv[2]);
    return 0;
}
