#include <iostream> 
#include <list> 
#include <iterator> 
#include <unordered_map>
#include <string>
#include <cstdlib>
// #include "cs_thread.h"
#include "cache.h"
using namespace std;
/* 
 * The idea behind cache implementation :
 * To implement LRU, Write-back, fully associative cache
 * MAX Cache size - 32 key-value pairs
 * Each cache node will consist of 1. key 2. value 3. dirty bit
 * Algo :
 * 1. Search in cache :
 * Use unordered_map to see if a key is present in the cache and if it is present, this operation
 * should return 1
 * This operation should also move searched key to start of the cache
 * 2. Insert in cache :
 * If cache is full, call LRU
 * If cache is not full, add the key-value pair to start of the cache 
 * 3. LRU cache :
 * (Use locality to evict more than one key-value pair?)
 * Delete the last element in cache
 * Insert new key-value pair at the start of the cache 
 * 
 * Data Structures : 1. List of cacheNode - 32 keys
 *                   2. Unordered map - <key, array index>
 *  
 */

#define MAX_CACHE_SIZE 3

list<cacheNode> cache;
unordered_map<string, list <cacheNode> :: iterator> hashTable;

/* 
 * Returns 1 if key-value pair is present in cache and 0 otherwise
 * If key is present, brings correspoding node to front of the cache(To identify recently used element)
 */
string search(string key) {
    unordered_map<string, list <cacheNode> :: iterator> :: iterator it = hashTable.find(key);
    if(it == hashTable.end()) {
        string ans = "";
        return ans;
    }
    else {
        list <cacheNode> :: iterator cnode_it = it->second;
        cache.push_front(*cnode_it);
        cache.erase(cnode_it);
        hashTable[key] = cache.begin();
        string ans = cnode_it->value;
        return ans;
    }
}

void lru(string key, string value) {
    list <cacheNode> :: iterator it = prev(cache.end());
    if(it->dirtyBit == '1') {
        // Write back to persistent storage
    } 
    else {
        int num = hashTable.erase(it->key);
        cache.pop_back();
        cacheNode cnode;
        cnode.key = key;
        cnode.value = value;
        cnode.dirtyBit = '0';
        cache.push_back(cnode);
        hashTable[key] = --cache.end();
    }
}

/*
 * Assumption here is that before calling insert, key-value pair does not already exist in cache
 */
void insert(string key, string value) {
    cacheNode cnode;
    if(cache.size() == MAX_CACHE_SIZE) {
        // printf("LRU called\n");
        lru(key, value);
    }
    else {
        cnode.key = key;
        cnode.value = value;
        cnode.dirtyBit = '0';
        cache.push_front(cnode);
        hashTable[key] = cache.begin();
    }
}

/*
 * Delete from cache
 */ 
string DEL(string key) {
    // printf("DEL function\n");
    unordered_map<string, list <cacheNode> :: iterator> :: iterator it = hashTable.find(key);
    list<cacheNode> :: iterator cnode_it = it->second;
    cache.erase(cnode_it);
    hashTable.erase(key);
    /*Need to add ravi code*/
    return "200";
}

string GET(string key) {
    // printf("GET function\n");
    string ans = search(key);
    /*need to add ravi code*/
    if(ans=="")
        return "200";
    return ans;
}

string PUT(string key, string value) {
    string ans = search(key);
    if(ans == "") {
        insert(key, value);
        /*Need to add ravi code */
    }
    else {
        unordered_map<string, list <cacheNode> :: iterator> :: iterator it = hashTable.find(key);
        it->second->value = value;
    }
    return "200";
}

/* 
 * Testing code
 */
// int main() {
//     string key1 = "AB";
//     string key2 = "BC";
//     string key3 = "CD";
//     string key4 = "DE";
//     string key5 = "EF";
//     string value  = "1";
//     insert(key1, value);
//     insert(key2, value);
//     for (auto p : hashTable) {
//         cout << p.first << " : ";
//         cout << p.second->key << " " << p.second->value << " " << p.second->dirtyBit << endl;
//     }
//     printf("-----------------------------\n");
//     insert(key3, value);
//     for (auto p : hashTable) {
//         cout << p.first << " : ";
//         cout << p.second->key << " " << p.second->value << " " << p.second->dirtyBit << endl;
//     }
//     printf("-----------------------------\n");
//     insert(key4, value);
//     for (auto p : hashTable) {
//         cout << p.first << " : ";
//         cout << p.second->key << " " << p.second->value << " " << p.second->dirtyBit << endl;
//     }
//     printf("-----------------------------\n");
//     cout << key1 << " " << search(key1) << endl; 
//     cout << key2 << " " << search(key2) << endl; 
//     cout << key3 << " " << search(key3) << endl; 
//     cout << key4 << " " << search(key4) << endl; 
//     printf("-----------------------------\n");
//     for (auto p : hashTable) {
//         cout << p.first << " : ";
//         cout << p.second->key << " " << p.second->value << " " << p.second->dirtyBit << endl;
//     }
//     printf("-----------------------------\n");
//     insert(key5, value);
//     for (auto p : hashTable) {
//         cout << p.first << " : ";
//         cout << p.second->key << " " << p.second->value << " " << p.second->dirtyBit << endl;
//     }
//     printf("-----------------------------\n");
//     DEL(key5);
//     for (auto p : hashTable) {
//         cout << p.first << " : ";
//         cout << p.second->key << " " << p.second->value << " " << p.second->dirtyBit << endl;
//     }
// }
