import socket
from threading import Thread
from socketserver import ThreadingMixIn
import concurrent.futures
import urllib.request
import random
import time
import sys

TCP_IP = sys.argv[1]
TCP_PORT = 9001
BUFFER_SIZE = 1024
tcpsock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
tcpsock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
tcpsock.bind((TCP_IP, TCP_PORT))
# threads = []

def calc_pow(num, raise_to):
    return num ** raise_to

def process_req(conn, ip, port):
    request = conn.recv(1024)
    print(request)
    request = request.decode('utf-8')
    num, raise_to = request.split(',')
    num = int(num)
    raise_to = int(raise_to)
    result = calc_pow(num, raise_to)
    result = str(result)
    conn.send(result.encode('ascii'))
    conn.close()
    return True

with concurrent.futures.ThreadPoolExecutor(max_workers = 2) as executor:
    future_to_pow = []
    while True :
        tcpsock.listen(5)
        print("Waiting for incoming connections....")
        (conn, (ip, port)) = tcpsock.accept()
        future_to_pow.append(executor.submit(process_req, conn, ip, port))
        # future_to_sort = [executor.submit(sort_list, l) for l in lol]
        if(len(future_to_pow) >= 50):
            for future in concurrent.futures.as_completed(future_to_pow):
                data = future.result()
            future_to_pow = []
