import sys
import libvirt
import time
import config
import threading
import socket

conn = libvirt.open('qemu:///system')
if conn == None:
    print('Failed to open connection to qemu:///system', file=sys.stderr)
    exit(1)

domainName = 'server1'
dom = conn.lookupByName(domainName)
if dom == None:
    print('Failed to get the domain object', file=sys.stderr)

f1 = open('server_ips.txt', 'w')
f1.write(config.new_server_ips[0])
f1.close()

def establish_conn(port):
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.settimeout(10)
    print("Trying to establish connection with replica server...")
    while(True):
        try:
            sock.connect((config.new_server_ips[-1], port))
            break
        except socket.error:
            pass
            # print("Connection error: {}".format(socket.error))
    print("Replica server is now online and accepting requests...")
    sock.settimeout(None)
    sock.close()

print("Monitor program started running...")
ind = 0
N = 5
t1 = threading.Thread(target = establish_conn, args = (9001,))
flag = False

while(True):
    cpu_stats1 = dom.getCPUStats(True)
    for (i, cpu) in enumerate(cpu_stats1):
        cpu_time1 = cpu['cpu_time'] / 1000000000 - cpu['system_time'] / 1000000000 - cpu['user_time'] / 1000000000
    if(flag == True):
        cpu_stats3 = dom1.getCPUStats(True)
        for (i, cpu) in enumerate(cpu_stats3):
            cpu_time3 = cpu['cpu_time'] / 1000000000 - cpu['system_time'] / 1000000000 - cpu['user_time'] / 1000000000
    time.sleep(N)
    cpu_stats2 = dom.getCPUStats(True)
    for (i, cpu) in enumerate(cpu_stats2):
        cpu_time2 = cpu['cpu_time'] / 1000000000 - cpu['system_time'] / 1000000000 - cpu['user_time'] / 1000000000
    if(flag == True) :
        cpu_stats4 = dom1.getCPUStats(True)
        for(i, cpu) in enumerate(cpu_stats4):
            cpu_time4 = cpu['cpu_time'] / 1000000000 - cpu['system_time'] / 1000000000 - cpu['user_time'] / 1000000000

    cpu_usage1 = 100 * (cpu_time2 - cpu_time1) / N
    print('CPU Usage of Server 1 : {}'.format(cpu_usage1))
    if(flag == True) :
        cpu_usage2 = 100 * (cpu_time4 - cpu_time3) / N
        print('CPU Usage of Server 2 : {}'.format(cpu_usage2))
    print('-------------------------------------------------------------')
    if(cpu_usage1 > 60.0):
        print('Overload detected')
        dom1 = conn.lookupByName('server2')
        flag = dom1.isActive()
        f = open('server2.xml', 'r')
        xmlconfig = " ".join(f.readlines())
        ind += 1
        if(flag == False): 
            dom1 = conn.defineXML(xmlconfig)
            if dom1 == None:
                print('Failed to define a domain from an XML definition', file=sys.stderr)
                exit(1)
            if dom1.create() < 0:
                print('Unable to boot replica guest server', file = sys.stderr)
                exit(1)
            print('Replica server has booted', file = sys.stderr)
            for lease in conn.networkLookupByName("default").DHCPLeases():
                if lease['ipaddr'] not in config.new_server_ips:
                    config.new_server_ips.append(lease['ipaddr'])
                    t1.start()
        else :
            if((dom1.isActive() == True) and (ind >= 3)):
                t1.join()
                f1 = open('server_ips.txt', 'w')
                for i in range(len(config.new_server_ips)):
                    f1.write(config.new_server_ips[i] + '\n')
                f1.close()
                # print(config.new_server_ips)
            
conn.close()
exit(0)