from __future__ import print_function
import socket
import concurrent.futures
import urllib.request
import random
import time
import sys
import libvirt
import config
import threading
from datetime import datetime, date

TCP_PORT = 9001
BUFFER_SIZE = 1024

request = '3,50'
server_index = 0

# server_ips = ['192.168.123.174'] 
server_ips = config.new_server_ips

def send_request(request, server_index):
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    s.settimeout(5)
    try :
        s.connect((server_ips[server_index], TCP_PORT))
        s.send(request.encode('ascii'))
        data = s.recv(BUFFER_SIZE)
        s.close()
    except :
        print('Response not received. Server {} offline.'.format(server_index + 1))
        data = b''
    return data

i = 0
print("Starting with low load...")
while(True) :
    if(i < 10) :
        l = [request] * 125
    elif(i == 10) :
        print("Shifting to high load...")
        l = [request] * 250
    else :
        l = [request] * 250
    server_index = (server_index + 1) % len(server_ips)
    f = open('server_ips.txt', 'r')
    server_ips = [line.strip() for line in f.readlines()]
    # print(config.new_server_ips)
    # print(server_ips)
    # print(server_index)
    start_time = datetime.now()
    with concurrent.futures.ThreadPoolExecutor(max_workers=2) as executor:
        req_sender = [executor.submit(send_request, request, server_index) for request in l]
        for future in concurrent.futures.as_completed(req_sender):
            data = future.result()
            # print(data)
    end_time = datetime.now()
    if(i < 10) :
        try :
            c = end_time - start_time
            milliseconds = (c.days * 24 * 60 * 60 + c.seconds) * 1000 + c.microseconds / 1000.0
            throughput = 125.0 / milliseconds
        except :
            throughput = 0.0
        print('Throughput of server {} : {}'.format(server_index + 1, throughput))
    else :
        try :
            c = end_time - start_time
            milliseconds = (c.days * 24 * 60 * 60 + c.seconds) * 1000 + c.microseconds / 1000.0
            throughput = 250.0 / milliseconds
        except :
            throughput = 0.0
        print('Throughput of server {} : {}'.format(server_index + 1, throughput))
    i += 1
    time.sleep(0.5)