from ecdsa import SigningKey,SECP256k1
from ecdsa.keys import BadSignatureError
from numpy.random import randint
import numpy as np

import binascii
import random
import scipy.stats as stats

def bytes_to_int(bytes):
    result = 0
    for b in bytes:
        result = result * 256 + int(b)
    return result

def pseudoRandomGenerator(seed) :
    random.seed(seed)
    return random.getrandbits(256)

def genratePublicPrivateKey():
    sk = SigningKey.generate(curve=SECP256k1)  # uses NIST192p
    vk = sk.get_verifying_key()
    signature = sk.sign(b"message")
    assert vk.verify(signature, b"message")
    return (sk,vk)

    pass

def VRF(sk,seed,pk):
    '''
    :param sk: secrete key
    :param seed:
    :param pk:  public key of user
    :return: (bytes array of signature may not b of fixed length | public key as a proof)
    '''
    prgoutput = pseudoRandomGenerator(seed)
    temp = bytes(str(prgoutput).encode('UTF8'))
    hash = sk.sign(temp)
    proof = pk
    return (hash,proof)

def verifyVRF(pk,hash,proof,seed):
    prgoutput = pseudoRandomGenerator(seed)
    temp = bytes(str(prgoutput).encode('UTF8'))
    try:
        proof.verify(hash, temp)
    except BadSignatureError as badSign:
        return False
    return True


def sortition(sk,seed,rolecount,role,w,badaW,pk):
    '''
    :param sk: secret key
    :param seed:
    :param rolecount: tou
    :param role:
    :param w: users stake or weight
    :param badaW: total stake in game i.e. sum of wi
    :param pk:  public key of user
    :return: (bytes array of signature may not b of fixed length | public key as a proof)
    '''

    newseed = (seed,role)
    hash,proof = VRF(sk, newseed, pk)
    p = rolecount/badaW
    j=0

    #simplifying the computation : hash/(2**hashlen)
    tempHash = bytes_to_int(hash[:32])  # converting first 32 bytes to integer i.e 32*8 bits ie 256 bits
    x = tempHash / (2 ** 256)

    # print(x)

    lastValue = 0
    # print("probability : ",p)


    flag = True
    while(flag):
        lastValue = lastValue + stats.binom.pmf(j, w, p)
        nextvalue = lastValue + stats.binom.pmf(j + 1, w, p)
        # print(lastValue,nextvalue)
        if (((lastValue<=x) and (x<nextvalue))):
            break
        if j == w+1:
            j=0
            break
        j = j+1

    return (hash,proof,j)


def verifySort(pk,hash,proof,seed,rolecount,role,w,badaW):
    '''
    :param pk: public key of user
    :param hash:
    :param proof:
    :param seed:
    :param rolecount: tou
    :param role:
    :param w: users stake or weight
    :param badaW: total stake in game i.e. sum of wi
    :return: number of selected users in commity for the user with pk
    '''

    newseed = (seed,role)
    if not verifyVRF(pk,hash,proof,newseed):
        return 0;

    p = rolecount/badaW
    j=0

    #simplifying the computation : hash/(2**hashlen)
    tempHash = bytes_to_int(hash[:32])  # converting first 32 bytes to integer i.e 32*8 bits ie 256 bits
    x = tempHash / (2 ** 256)

    # print(x)

    lastValue = 0;
    # print("probability : ",p)


    flag = True
    while(flag):
        lastValue = lastValue + stats.binom.pmf(j, w, p)
        nextvalue = lastValue + stats.binom.pmf(j + 1, w, p)
        # print(lastValue,nextvalue)
        if (((lastValue<=x) and (nextvalue>x))):
            break
        if j == w+1:
            j=0
            break
        j = j+1

    if j :
        print("Verification success : J :",j,role)

    return j

# def computeRange():
#     badaW=10
#     lastValue = 0;
#     p = 0.5
#     x = 0.0023
#     j = 0
#     if (x<=stats.binom.pmf(0, badaW, p)):
#         j = 0
#     else :
#         for k in range(0,badaW+1):
#             lastValue = lastValue +  stats.binom.pmf(k, badaW, p)
#             nextvalue =lastValue+ stats.binom.pmf(k+1, badaW, p)
#             print(lastValue)
#             print(nextvalue)
#             print("------------")
#             j =j+1
#



def testingBinom():
    w = 1
    p=0.2
    m = 0
    for k in range(0,2):
        ev = stats.binom.pmf(k, w, p)
        m = m+ ev
        print(ev)

    print(m)

def testHashlen():
    keypair = genratePublicPrivateKey()
    seed = ("a", 1, 2)
    x = VRF(keypair[0], seed,  keypair[1])
    print(len(binascii.hexlify(x[0])))
    print(len(x[0]))
    temp = bytes_to_int(x[0][:32])  # converting first 32 bytes to integer i.e 32*8 bits ie 256 bits

    print(temp / (2 ** 256)) #computes something simalar to hash/(2**haslen)

def testSortition():
    sk,pk = genratePublicPrivateKey()
    seed = ("a",1,2)
    roleCount = 26
    role = "LEAD"
    w = 20
    badaW = 100
    hash,proof,j = sortition(sk,seed,roleCount,role,w,badaW,pk)
    # print(hash) #this is a real content of hash it should be used as final thing and not hexlify
    print(binascii.hexlify(hash))
    print(proof)
    print(j)

def tester():
    sk,pk = genratePublicPrivateKey()
    seed = ("a",1,2)
    roleCount = 26
    role = "LEAD"
    # w= randint(1,100000,10)
    w = [ 1, 10,100, 500, 1000,5000, 8000, 10000 ]
    w.sort()
    print(w)
    # w = 20
    badaW = np.sum(w)
    print(badaW)

    for i in w:
       hash,proof,j = sortition(sk,seed,roleCount,role,i,badaW,pk)
    # print(hash) #this is a real content of hash it should be used as final thing and not hexlify
    # print(binascii.hexlify(hash))
    # print(proof)
       print("w = " + str(i) , "w/badaW = ", str(i/badaW), "j = " ,str(j))

def testVerifySort():
    sk, pk = genratePublicPrivateKey()
    seed = ("a", 1, 2)
    roleCount = 26
    role = "LEAD"
    w = 20
    badaW = 100
    hash, proof, j = sortition(sk, seed, roleCount, role, w, badaW, pk)
    # print(hash) #this is a real content of hash it should be used as final thing and not hexlify
    print("-----sortition output -----------")
    print(binascii.hexlify(hash))
    print(proof)
    print(j)
    print("----------------------------------")

    seed2 = ("a", 1, 2)
    roleCount2 = 26
    role2 = "LEAD"
    w2 = 20
    badaW = 100
    y = verifySort(pk,hash,proof, seed2, roleCount2, role2, w2, badaW)
    print(y)
    assert (j==y),"Test VerifySort failed : "


    seed3 = ("a", 1, 2)
    roleCount3 = 26
    role3 = "Commitee"
    w3 = 20
    badaW = 100
    y = verifySort(pk,hash,proof, seed3, roleCount3, role3, w3, badaW)
    print(y)
    assert (y==0),"Test Verify sort failed : change of seed not detected"

def tester():
    '''
    tests if sortition distributes the stake
    :return:
    '''
    sk,pk = genratePublicPrivateKey()
    seed = ("a",1,2)
    roleCount = 26
    role = "LEAD"
    # w= randint(1,100000,10)
    w = [ 1, 10,100, 500, 1000,5000, 8000, 10000 ]
    w.sort()
    print(w)
    # w = 20
    badaW = np.sum(w)
    print(badaW)

    for i in w:
       hash,proof,j = sortition(sk,seed,roleCount,role,i,badaW,pk)
    # print(hash) #this is a real content of hash it should be used as final thing and not hexlify
    # print(binascii.hexlify(hash))
    # print(proof)
       print("w = " + str(i) , "w/badaW = ", str(i/badaW), "j = " ,str(j))

def testVerifyVRF():
    sk,pk = genratePublicPrivateKey()
    seed = ("a",1,2)
    hash,proof= VRF(sk,seed,pk)
    seed2 = ("a", 1, 2)
    status = verifyVRF(pk,hash,proof,seed2)
    print(status)


if __name__ == '__main__':
    # testSortition()
    # testVerifyVRF()
    # testVerifySort(0
    tester()
