from Network import Network
import csv

import logging

logger = logging.getLogger(__name__)


def populateTodolist(net):
    if not net:
        network = Network()
        network.setupNetwork()
    else:
        network = net
    with open('todolist.dat', 'r') as f:
        reader = csv.reader(f)
        for row in reader:
            instruction = row[0].split()  # tuple of a link
            node = network.nodes.get(instruction[0])
            node.todoList[instruction[1]].append(tuple(instruction[2:]))
    # for id, node in network.nodes.items():
    #     node.todoList['0'].append(("nextOn",node.startNodeLifeCycleGenerator,))

    for id,node in network.nodes.items():
        # logger.info(id +" : "+str(node.todoList))
        pass

def simulateNetwork(net):
    if not net:
        network = Network()
        network.setupNetwork()
    else:
        network = net

    populateTodolist(network)

    for time in range(7):
        logger.info("TIme : "+str(time))
        network.simulate(str(time))


if __name__ == '__main__':
    logging.basicConfig(filename='TestCases.log', level=logging.INFO)
    # populateTodolist(None)
    # simulateNetwork(None)
    ak = ['hello','ramesh']
    ak.append('rao')
    if 'hello' in ak:
        print("yay")
    print(ak.pop())

    pass
