from SystemEntity import SystemEntity
import logging
import Utility
import hashlib
from collections import defaultdict

class Node(SystemEntity):
    def __init__(self,id,network,weight):
        SystemEntity.__init__(self,network)
        self.logger = logging.getLogger(__name__ + "-" + str(id))

        self.id = id
        self.weight = weight
        self.adjacentNodes = []
        self.messageQueue = []
        self.sk,self.pk = Utility.genratePublicPrivateKey()
        self.ResumeTasks = defaultdict(list)
        '''make sure methods included here are not overriddenn'''
        self.commands={"sendMessage":self.sendMessage,
                       "nextOn":self.nextOn

                       }
        self.messagesTillNow = [] # list of messages forwarded
        self.uniqueReceivedMessages = defaultdict(list) #this is a list of messages in buffer which were not processed, expecting two list of 'BLOCK_PROPOSAL_MSG','PRIORITY_MSG'


    def enqueMessage(self,message):
        '''

        :param message: (timestamp , payload)    --- timestamp is the tick value at which node has inserted this message in queue
        payload #1 : ('NOde1', 'Node2', 'Content of message')
        payload #2 :

        :return:
        '''
        self.messageQueue.append(message)
        # print("message enqued")

    def dequeMessage(self):
        return self.messageQueue.pop(0)



    def sendMessage(self,time,params):
        '''

        :param params: ('1','2','hello2')
        :return:
        '''
        link = self.network.getLink((params[0],params[1]))
        link.enqueMessage((time,params))
        # any message going out is recorded as sent and will be checked for duplicates
        self.messagesTillNow.append(hashlib.sha256((str(params[2])).encode('utf-8')).hexdigest())
        ###### self.logger.info("Sending : " + str((time,params)))#(time,(sender,receiver,payload))
        pass

    def broadcast(self,time,gossipPayload):
        '''

        :param time:
        :param gossipPayload:
        :return:

        broadcast and processMessage together makes it gossip protocol
        '''
        self.messagesTillNow.append(hashlib.sha256((str(gossipPayload)).encode('utf-8')).hexdigest())
        for nodeid in self.adjacentNodes:
            node = self.network.nodes.get(nodeid)
            link = self.network.getLink((self.id, node.id))
            link.enqueMessage((time, (self.id, node.id,gossipPayload)))
            ###### self.logger.info("Sending : " + str((time, (self.id, node.id,gossipPayload))))#(time,(sender,receiver,payload))

    def processMessage(self,time,payload):
        '''remove any extra headers like source and destination here '''
        payload.pop(0) # removed source header
        payload.pop(0) #removed destination header

        # TODO check messages for duplicates and brodacast them : Done
        if not (hashlib.sha256((str(payload[0])).encode('utf-8')).hexdigest() in self.messagesTillNow) :
            self.broadcast(time,payload[0])
            self.uniqueReceivedMessages[payload[0][0]].append(payload[0])

    def nextOn(self,time,generator):
        return next(generator[0])

    def startNodeLifeCycle(self):
        pass


    def simulate(self,time):
        # self.logger.info("simulating .. ")
        '''
        Process message first then process task in todo list
        Here it is just intuition , i don`t what should be processing sequence
        
        all messages will be proceessed i.e., at the end of each tick simulation links will not have 
        any unprocessed message the receive buffer or message-queue 

        '''
        # todo process messages in queue
        # generate tasks for todolist based on messges
        for message in list(self.messageQueue): #this creates adupliacte list and iterate over it while making changes to original queue
            self.processMessage(message[0],list(message[1])) # message : (time,(payload))
            # self.logger.info("received : "+str(message))
            self.dequeMessage()

        # check if main ba* has to be resumed or not
        try:
            ResumeTasks = self.ResumeTasks.pop(time)
            for ResumeTask in ResumeTasks:
                command = self.commands.get(ResumeTask[0])
                ResumeOut = command(time,ResumeTask[1:])
                '''
                    synatx for proper return commands
                    yield "resume",timeafter_which_to_resume
                '''
                if ResumeOut and ResumeOut[0] == "resume":
                    self.logger.info("resume has been called")
                    self.ResumeTasks[str(int(time)+int(ResumeOut[1]))].append(("nextOn", self.startNodeLifeCycleGenerator,))
        except KeyError as ke:
            # not task pending at this time
            pass
        except StopIteration as si:
            pass
        except IndexError as Ie:
            self.logger.info("No resume task from ba*")



        # TODO : perform task from todolist which are relevant for current tick

        try:
            tasks = self.todoList.pop(time)
            for task in tasks:
                command = self.commands.get(task[0])
                out = command(time,task[1:])
        except KeyError as ke:
            # not task pending at this time
            pass



if __name__ == '__main__':
    # node = Node('1')
    # cmd = node.commands.get("sendMessage")
    # cmd("1 ","2 "," : Hello world")
    x = [1,2,3,4,5,6]
    for i in list(x):
        y= x.pop(0)
        print(y)

    print(x)




